package com.biz.crm.sfa.business.template.competing.goods.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.UuidEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

/**
 * 竞品采集清单表
 *
 * @author songjingen
 * @date 2022/6/8
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "CompetingGoodsCollectInventory", description = "竞品采集清单表")
@Entity
@TableName("sfa_competing_goods_collect_inventory")
@Table(name = "sfa_competing_goods_collect_inventory")
@org.hibernate.annotations.Table(appliesTo = "sfa_competing_goods_collect_inventory", comment = "竞品采集清单表")
public class CompetingGoodsCollectInventory extends UuidEntity {

  private static final long serialVersionUID = -2765289943786899179L;
  /**
   * 采集编码
   */
  @ApiModelProperty("采集编码")
  @Column(name = "collect_code", length = 64, nullable = false, columnDefinition = "VARCHAR(64) COMMENT '采集编码'")
  private String collectCode;

  /**
   * 竞品id
   */
  @ApiModelProperty("竞品id")
  @Column(name = "goods_id", length = 64, nullable = false, columnDefinition = "VARCHAR(64) COMMENT '竞品id'")
  private String goodsId;

  /**
   * 铺货数量
   */
  @ApiModelProperty("铺货数量")
  @Column(name = "goods_quantity", length = 8, nullable = false, columnDefinition = "int(8) COMMENT '铺货数量'")
  private Integer goodsQuantity = 0;

}
