package com.biz.crm.sfa.business.template.competing.goods.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.FileEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

/**
 * 竞品采集图片表
 *
 * @author songjingen
 * @date 2022/6/8
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "CompetingGoodsCollectPicture", description = "竞品采集图片表")
@Entity
@TableName("sfa_competing_goods_collect_picture")
@Table(name = "sfa_competing_goods_collect_picture")
@org.hibernate.annotations.Table(appliesTo = "sfa_competing_goods_collect_picture", comment = "竞品采集图片表")
public class CompetingGoodsCollectPicture extends FileEntity {

  private static final long serialVersionUID = -2765289943786899179L;

  /**
   * 采集编码
   */
  @ApiModelProperty("采集编码")
  @Column(name = "collect_code", length = 64, nullable = false, columnDefinition = "VARCHAR(64) COMMENT '采集编码'")
  private String collectCode;

}
