package com.biz.crm.sfa.business.template.competing.goods.local.model;

import com.biz.crm.common.form.sdk.field.annotation.DynamicField;
import com.biz.crm.common.form.sdk.field.annotation.Validate;
import com.biz.crm.common.form.sdk.field.validate.NotBlankValidateStrategy;
import com.biz.crm.common.form.sdk.widget.SimpleInputWidget;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

/**
 * 竞品采集清单model
 *
 * @author songjingen
 * @date 2022/6/8
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "CompetingGoodsCollectInventory", description = "竞品采集清单model")
public class GoodsCollectInventoryModel {

  private static final long serialVersionUID = -2765289943786899179L;

  /**
   * id
   */
  @ApiModelProperty("id")
  private String id;
  /**
   * 竞品id
   */
  @ApiModelProperty("竞品id")
  @DynamicField(fieldName = "竞品id", validates = {@Validate(value = NotBlankValidateStrategy.class)}, controllKey = SimpleInputWidget.class)
  private String goodsId;

  /**
   * 竞品名称
   */
  @ApiModelProperty("竞品名称")
  private String collectCode;

  /**
   * 竞品名称
   */
  @ApiModelProperty("竞品名称")
  private String goodsName;

  /**
   * 所属品牌
   */
  @ApiModelProperty("所属品牌")
  private String goodsBrand;
  /**
   * 所属系列
   */
  @ApiModelProperty("所属系列")
  private String goodsSerial;

  /**
   * 铺货数量
   */
  @ApiModelProperty("铺货数量")
  @DynamicField(fieldName = "铺货数量", validates = {@Validate(value = NotBlankValidateStrategy.class)}, controllKey = SimpleInputWidget.class)
  private Integer goodsQuantity = 0;

}
