package com.biz.crm.sfa.business.template.competing.goods.local.model;

import com.biz.crm.common.form.sdk.field.annotation.DynamicField;
import com.biz.crm.common.form.sdk.field.annotation.Validate;
import com.biz.crm.common.form.sdk.field.validate.NotBlankValidateStrategy;
import com.biz.crm.common.form.sdk.widget.SimpleInputWidget;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

/**
 * 竞品采集图片model
 *
 * @author songjingen
 * @date 2022/6/8
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "GoodsCollectPictureModel", description = "竞品采集图片model")
public class GoodsCollectPictureModel {

  private static final long serialVersionUID = -2765289943786899179L;

  /**
   * 文件唯一识别号
   */
  @ApiModelProperty(value = "文件唯一识别号")
  @DynamicField(fieldName = "文件唯一识别号", validates = {@Validate(value = NotBlankValidateStrategy.class)}, controllKey = SimpleInputWidget.class)
  private String fileCode;

  /**
   * 原始文件名
   */
  @ApiModelProperty(name = "originalFileName", value = "原始文件名")
  @DynamicField(fieldName = "原始文件名", validates = {@Validate(value = NotBlankValidateStrategy.class)}, controllKey = SimpleInputWidget.class)
  private String originalFileName;

}
