package com.biz.crm.sfa.business.template.competing.goods.local.repository;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.sfa.business.template.competing.goods.local.entity.CompetingGoodsCollectInventory;
import com.biz.crm.sfa.business.template.competing.goods.local.mapper.CompetingGoodsCollectInventoryMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 竞品采集清单表(CompetingGoodsCollectInventory)表数据库访问层
 *
 * @author songjingen
 * @since 2022-06-16 19:45:39
 */
@Component
public class CompetingGoodsCollectInventoryRepository extends ServiceImpl<CompetingGoodsCollectInventoryMapper, CompetingGoodsCollectInventory> {

  @Autowired
  private CompetingGoodsCollectInventoryMapper competingGoodsCollectInventoryMapper;

  /**
   * 分页查询数据
   *
   * @param pageable                       分页对象
   * @param competingGoodsCollectInventory 实体对象
   * @return
   */
  public Page<CompetingGoodsCollectInventory> findByConditions(Pageable pageable, CompetingGoodsCollectInventory competingGoodsCollectInventory) {
    Page<CompetingGoodsCollectInventory> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    Page<CompetingGoodsCollectInventory> pageList = this.competingGoodsCollectInventoryMapper.findByConditions(page, competingGoodsCollectInventory);
    return pageList;
  }

  /**
   * 根据采集编码删除数据
   *
   * @param collectCode
   */
  public void deleteByCollectCode(String collectCode) {
    this.lambdaUpdate().eq(CompetingGoodsCollectInventory::getCollectCode, collectCode).remove();
  }

  /**
   * 根据采集编码查询数据集合
   *
   * @param collectCode
   * @return
   */
  public List<CompetingGoodsCollectInventory> findByCollectCode(String collectCode) {
    return this.lambdaQuery().eq(CompetingGoodsCollectInventory::getCollectCode, collectCode).list();
  }
}

