package com.biz.crm.sfa.business.template.competing.goods.local.repository;


import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.sfa.business.template.competing.goods.local.entity.CompetingGoodsCollectPicture;
import com.biz.crm.sfa.business.template.competing.goods.local.mapper.CompetingGoodsCollectPictureMapper;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 竞品采集图片表(CompetingGoodsCollectPicture)表数据库访问层
 *
 * @author songjingen
 * @since 2022-06-16 19:45:39
 */
@Component
public class CompetingGoodsCollectPictureRepository extends ServiceImpl<CompetingGoodsCollectPictureMapper, CompetingGoodsCollectPicture> {

  /**
   * 根据采集编码删除数据
   *
   * @param collectCode
   */
  public void deleteByCollectCode(String collectCode) {
    this.lambdaUpdate().eq(CompetingGoodsCollectPicture::getCollectCode, collectCode).remove();
  }

  /**
   * 根据采集编码查询数据结合
   *
   * @param collectCode
   * @return
   */
  public List<CompetingGoodsCollectPicture> findByCollectCode(String collectCode) {
    return this.lambdaQuery().eq(CompetingGoodsCollectPicture::getCollectCode, collectCode).list();
  }
}

