package com.biz.crm.sfa.business.template.competing.goods.local.repository;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.sfa.business.template.competing.goods.local.entity.CompetingGoods;
import com.biz.crm.sfa.business.template.competing.goods.local.mapper.CompetingGoodsMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 竞品商品表(CompetingGoods)表数据库访问层
 *
 * @author songjingen
 * @since 2022-06-16 19:45:38
 */
@Component
public class CompetingGoodsRepository extends ServiceImpl<CompetingGoodsMapper, CompetingGoods> {

  @Autowired
  private CompetingGoodsMapper competingGoodsMapper;

  /**
   * 分页查询数据
   *
   * @param pageable       分页对象
   * @param competingGoods 实体对象
   * @return
   */
  public Page<CompetingGoods> findByConditions(Pageable pageable, CompetingGoods competingGoods) {
    Page<CompetingGoods> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    Page<CompetingGoods> pageList = this.competingGoodsMapper.findByConditions(page, competingGoods);
    return pageList;
  }

  /**
   * 根据id集合更新启禁用装填
   *
   * @param ids          分页对象
   * @param enableStatus 启禁用状态对象
   * @return
   */
  public void updateEnableStatusByIds(List<String> ids, EnableStatusEnum enableStatus) {
    this.lambdaUpdate()
        .in(CompetingGoods::getId, ids)
        .set(CompetingGoods::getEnableStatus, enableStatus.getCode())
        .update();
  }

  /**
   * 更改删除状态
   *
   * @param idList
   * @param delFlagStatusEnum
   */
  public void updateDelFlagByIds(List<String> idList, DelFlagStatusEnum delFlagStatusEnum) {
    this.lambdaUpdate()
        .set(CompetingGoods::getDelFlag, delFlagStatusEnum.getCode())
        .in(CompetingGoods::getId, idList)
        .update();
  }
}

