package com.biz.crm.sfa.business.template.competing.goods.local.service;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.sfa.business.template.competing.goods.local.entity.CompetingGoods;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * 竞品商品表(CompetingGoods)表服务接口
 *
 * @author songjingen
 * @since 2022-06-16 19:45:38
 */
public interface CompetingGoodsService {

  /**
   * 分页查询数据
   *
   * @param pageable       分页对象
   * @param competingGoods 实体对象
   * @return
   */
  Page<CompetingGoods> findByConditions(Pageable pageable, CompetingGoods competingGoods);

  /**
   * 通过主键查询单条数据
   *
   * @param id 主键
   * @return 单条数据
   */
  CompetingGoods findById(String id);

  /**
   * 新增数据
   *
   * @param competingGoods 实体对象
   * @return 新增结果
   */
  CompetingGoods create(CompetingGoods competingGoods);

  /**
   * 修改新据
   *
   * @param competingGoods 实体对象
   * @return 修改结果
   */
  CompetingGoods update(CompetingGoods competingGoods);

  /**
   * 删除数据
   *
   * @param idList 主键结合
   * @return 删除结果
   */
  void delete(List<String> idList);

  /**
   * 启用（单个或者批量）
   *
   * @param idList 主键结合
   * @return 启用结果
   */
  void enable(List<String> idList);

  /**
   * 禁用（单个或者批量）
   *
   * @param idList 主键结合
   * @return 禁用结果
   */
  void disable(List<String> idList);

}

