package com.biz.crm.sfa.business.template.competing.goods.local.service.internal;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.identity.FacturerUserDetails;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.sfa.business.template.competing.goods.local.entity.CompetingGoodsCollect;
import com.biz.crm.sfa.business.template.competing.goods.local.entity.CompetingGoodsCollectInventory;
import com.biz.crm.sfa.business.template.competing.goods.local.entity.CompetingGoodsCollectPicture;
import com.biz.crm.sfa.business.template.competing.goods.local.repository.CompetingGoodsCollectRepository;
import com.biz.crm.sfa.business.template.competing.goods.local.service.CompetingGoodsCollectInventoryService;
import com.biz.crm.sfa.business.template.competing.goods.local.service.CompetingGoodsCollectPictureService;
import com.biz.crm.sfa.business.template.competing.goods.local.service.CompetingGoodsCollectService;
import com.biz.crm.sfa.business.template.competing.goods.sdk.constant.CompetingGoodsConstant;
import com.biz.crm.sfa.business.template.competing.goods.sdk.dto.CompetingGoodsCollectPageDto;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Objects;

/**
 * 竞品采集表(CompetingGoodsCollect)表服务实现类
 *
 * @author songjingen
 * @since 2022-06-16 19:45:38
 */
@Service("competingGoodsCollectService")
public class CompetingGoodsCollectServiceImpl implements CompetingGoodsCollectService {

  @Autowired
  private CompetingGoodsCollectRepository competingGoodsCollectRepository;
  @Autowired
  private CompetingGoodsCollectPictureService goodsCollectPictureService;
  @Autowired
  private CompetingGoodsCollectInventoryService goodsCollectInventoryService;
  @Autowired(required = false)
  private GenerateCodeService generateCodeService;
  @Autowired(required = false)
  private LoginUserService loginUserService;

  /**
   * 分页查询数据
   *
   * @param pageable 分页对象
   * @param dto      实体对象
   * @return
   */
  @Override
  public Page<CompetingGoodsCollect> findByConditions(Pageable pageable, CompetingGoodsCollectPageDto dto) {
    ObjectUtils.defaultIfNull(pageable, PageRequest.of(0, 50));
    if (Objects.isNull(dto)) {
      dto = new CompetingGoodsCollectPageDto();
    }
    dto.setTenantCode(TenantUtils.getTenantCode());
    Page<CompetingGoodsCollect> byConditions = this.competingGoodsCollectRepository.findByConditions(pageable, dto);
    return byConditions;
  }

  /**
   * 新增数据
   *
   * @param competingGoodsCollect 实体对象
   * @return 新增结果
   */
  @Transactional
  @Override
  public CompetingGoodsCollect create(CompetingGoodsCollect competingGoodsCollect) {
    this.createValidate(competingGoodsCollect);
    List<CompetingGoodsCollectInventory> inventories = competingGoodsCollect.getInventories();
    List<CompetingGoodsCollectPicture> pictures = competingGoodsCollect.getPictures();
    Validate.isTrue(!CollectionUtils.isEmpty(inventories), "采集信息时，商品清单不能为空！");
    Validate.isTrue(!CollectionUtils.isEmpty(pictures), "采集信息时，采集图片不能为空！");
    this.competingGoodsCollectRepository.saveOrUpdate(competingGoodsCollect);
    //保存关联表信息
    inventories.stream().forEach(competingGoodsCollectInventory -> competingGoodsCollectInventory.setCollectCode(competingGoodsCollect.getCollectCode()));
    pictures.stream().forEach(competingGoodsCollectPicture -> competingGoodsCollectPicture.setCollectCode(competingGoodsCollect.getCollectCode()));
    this.goodsCollectInventoryService.createBatch(inventories);
    this.goodsCollectPictureService.createBatch(pictures);
    return competingGoodsCollect;
  }

  /**
   * 修改新据
   *
   * @param competingGoodsCollect 实体对象
   * @return 修改结果
   */
  @Transactional
  @Override
  public CompetingGoodsCollect update(CompetingGoodsCollect competingGoodsCollect) {
    Validate.notNull(competingGoodsCollect, "修改时，对象信息不能为空！");
    Validate.notBlank(competingGoodsCollect.getId(), "修改数据时，主键id不能为空！");
    List<CompetingGoodsCollectInventory> inventories = competingGoodsCollect.getInventories();
    List<CompetingGoodsCollectPicture> pictures = competingGoodsCollect.getPictures();
    Validate.isTrue(!CollectionUtils.isEmpty(inventories), "采集信息时，商品清单不能为空！");
    Validate.isTrue(!CollectionUtils.isEmpty(pictures), "采集信息时，采集图片不能为空！");
    CompetingGoodsCollect goodsCollect = this.competingGoodsCollectRepository.getById(competingGoodsCollect.getId());
    Validate.notNull(goodsCollect, "修改时，未查询到要修改的数据！");
    BeanUtils.copyProperties(competingGoodsCollect, goodsCollect, "id", "parentCode", "dynamicKey", "dynamicFormCode", "collectCode", "createTime", "tenantCode", "createAccount", "createName");
    this.updateValidate(goodsCollect);
    this.competingGoodsCollectRepository.saveOrUpdate(goodsCollect);
    //保存关联表信息
    String collectCode = goodsCollect.getCollectCode();
    inventories.stream().forEach(competingGoodsCollectInventory -> competingGoodsCollectInventory.setCollectCode(collectCode));
    pictures.stream().forEach(competingGoodsCollectPicture -> competingGoodsCollectPicture.setCollectCode(collectCode));
    this.goodsCollectInventoryService.deleteByCollectCode(collectCode);
    this.goodsCollectPictureService.deleteByCollectCode(collectCode);
    this.goodsCollectInventoryService.createBatch(inventories);
    this.goodsCollectPictureService.createBatch(pictures);
    return goodsCollect;
  }

  /**
   * 删除数据
   *
   * @param idList 主键结合
   * @return 删除结果
   */
  @Transactional
  @Override
  public void delete(List<String> idList) {
    Validate.isTrue(!CollectionUtils.isEmpty(idList), "删除数据时，主键集合不能为空！");
    this.competingGoodsCollectRepository.removeByIds(idList);
  }

  /**
   * 创建验证
   *
   * @param competingGoodsCollect
   */
  private void createValidate(CompetingGoodsCollect competingGoodsCollect) {
    FacturerUserDetails loginDetails = this.loginUserService.getLoginDetails(FacturerUserDetails.class);
    Validate.notNull(competingGoodsCollect, "新增时，对象信息不能为空！");
    competingGoodsCollect.setId(null);
    competingGoodsCollect.setTenantCode(TenantUtils.getTenantCode());
    competingGoodsCollect.setPostCode(loginDetails.getPostCode());
    competingGoodsCollect.setPostName(loginDetails.getPostName());
    competingGoodsCollect.setCollectCode(this.generateCodeService.generateCode(CompetingGoodsConstant.COMPETING_GOODS_COLLECT_CODE, 1).get(0));
    Validate.notBlank(competingGoodsCollect.getTenantCode(), "新增数据时，租户编号不能为空！");
    Validate.notBlank(competingGoodsCollect.getActionInfo(), "新增数据时，活动信息不能为空！");
    Validate.notBlank(competingGoodsCollect.getCollectCode(), "新增数据时，采集编码不能为空！");
    Validate.notBlank(competingGoodsCollect.getClientCode(), "新增数据时，客户编码不能为空！");
    Validate.notBlank(competingGoodsCollect.getClientType(), "新增数据时，客户类型不能为空！");
    CompetingGoodsCollect byParentCodeAndDynamicKey = this.competingGoodsCollectRepository.findByParentCodeAndDynamicKey(competingGoodsCollect.getParentCode(), competingGoodsCollect.getDynamicKey());
    Validate.isTrue(byParentCodeAndDynamicKey == null, "新增数据时，当前执行计划已提交数据，请勿重复提交！");
  }

  /**
   * 修改验证
   *
   * @param competingGoodsCollect
   */
  private void updateValidate(CompetingGoodsCollect competingGoodsCollect) {
    FacturerUserDetails loginDetails = this.loginUserService.getLoginDetails(FacturerUserDetails.class);
    competingGoodsCollect.setPostCode(loginDetails.getPostCode());
    competingGoodsCollect.setPostName(loginDetails.getPostName());
    Validate.notBlank(competingGoodsCollect.getTenantCode(), "修改数据时，租户编号不能为空！");
    Validate.notBlank(competingGoodsCollect.getActionInfo(), "修改数据时，活动信息不能为空！");
    Validate.notBlank(competingGoodsCollect.getCollectCode(), "修改数据时，采集编码不能为空！");
    Validate.notBlank(competingGoodsCollect.getClientCode(), "修改数据时，客户编码不能为空！");
    Validate.notBlank(competingGoodsCollect.getClientType(), "修改数据时，客户类型不能为空！");
  }
}

