package com.biz.crm.sfa.business.template.competing.goods.local.strategy;

import com.biz.crm.common.form.sdk.model.DynamicFormOperationStrategy;
import com.biz.crm.sfa.business.step.sdk.register.StepFormModuleRegister;
import com.biz.crm.sfa.business.template.competing.goods.local.entity.CompetingGoodsCollect;
import com.biz.crm.sfa.business.template.competing.goods.local.model.GoodsCollectModel;
import com.biz.crm.sfa.business.template.competing.goods.local.service.CompetingGoodsCollectService;
import com.biz.crm.sfa.business.template.competing.goods.local.service.GoodsCollectModelService;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.HashSet;

/**
 * 专门为具体的CpuAccessory业务模型服务的操作策略
 *
 * @author yinwenjie
 */
@Component
public class DynamicFormOperationStrategyForGoodsCollectModel implements DynamicFormOperationStrategy<GoodsCollectModel> {

  @Autowired
  private StepFormModuleRegister stepFormModuleRegister;
  @Autowired(required = false)
  private NebulaToolkitService nebulaToolkitService;
  @Autowired
  private CompetingGoodsCollectService competingGoodsCollectService;
  @Autowired
  private GoodsCollectModelService goodsCollectModelService;

  /**
   * 日志
   */
  private static final Logger LOGGER = LoggerFactory.getLogger(DynamicFormOperationStrategyForGoodsCollectModel.class);

  @Override
  public int getOrder() {
    return 9;
  }

  @Override
  public String dynamicFormCode() {
    return StringUtils.uncapitalize(this.getClass().getSimpleName());
  }

  @Override
  public String dynamicFormName() {
    return "示例-竞品采集";
  }

  @Override
  public Class<GoodsCollectModel> dynamicFormClass() {
    return GoodsCollectModel.class;
  }

  @Override
  public String moduleCode() {
    return this.stepFormModuleRegister.moduleCode();
  }

  @Override
  public void onDynamicFormsDelete(String parentCode, String dynamicKey) {
    LOGGER.info("onDynamicFormsDelete(String parentCode, String dynamicKey)");
  }

  @Override
  public void onDynamicFormCreate(GoodsCollectModel dynamicForm, String dynamicKey, String parentCode, Object parent) {
    dynamicForm.setParentCode(parentCode);
    dynamicForm.setDynamicKey(dynamicKey);
    CompetingGoodsCollect competingGoodsCollect = this.nebulaToolkitService.copyObjectByWhiteList(dynamicForm, CompetingGoodsCollect.class, HashSet.class, ArrayList.class, "pictures", "inventories");
    this.competingGoodsCollectService.create(competingGoodsCollect);
  }

  @Override
  public void onDynamicFormModify(GoodsCollectModel dynamicForm, String dynamicKey, String parentCode, Object parent) {
    dynamicForm.setParentCode(parentCode);
    dynamicForm.setDynamicKey(dynamicKey);
    CompetingGoodsCollect competingGoodsCollect = this.nebulaToolkitService.copyObjectByWhiteList(dynamicForm, CompetingGoodsCollect.class, HashSet.class, ArrayList.class, "pictures", "inventories");
    this.competingGoodsCollectService.update(competingGoodsCollect);
  }

  @Override
  public GoodsCollectModel findByParentCode(String dynamicKey, String parentCode) {
    if (StringUtils.isAnyBlank(dynamicKey, parentCode)) {
      return null;
    }
    GoodsCollectModel goodsCollectModel = this.goodsCollectModelService.findByParentCodeAndDynamicKey(parentCode, dynamicKey);
    return goodsCollectModel;
  }
}
