/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sfa.business.template.competing.goods.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.sfa.business.template.competing.goods.local.entity.CompetingGoods;
import com.biz.crm.sfa.business.template.competing.goods.local.repository.CompetingGoodsRepository;
import com.biz.crm.sfa.business.template.competing.goods.local.service.CompetingGoodsService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="competingGoodsService")
public class CompetingGoodsServiceImpl
implements CompetingGoodsService {
    @Autowired
    private CompetingGoodsRepository competingGoodsRepository;
    @Autowired
    private GenerateCodeService generateCodeService;

    @Override
    public Page<CompetingGoods> findByConditions(Pageable pageable, CompetingGoods competingGoods) {
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (Objects.isNull((Object)competingGoods)) {
            competingGoods = new CompetingGoods();
        }
        competingGoods.setTenantCode(TenantUtils.getTenantCode());
        return this.competingGoodsRepository.findByConditions(pageable, competingGoods);
    }

    @Override
    public CompetingGoods findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return (CompetingGoods)((Object)this.competingGoodsRepository.getById((Serializable)((Object)id)));
    }

    @Override
    @Transactional
    public CompetingGoods create(CompetingGoods competingGoods) {
        this.createValidate(competingGoods);
        this.competingGoodsRepository.saveOrUpdate((Object)competingGoods);
        return competingGoods;
    }

    @Override
    @Transactional
    public CompetingGoods update(CompetingGoods competingGoods) {
        Validate.notNull((Object)((Object)competingGoods), (String)"\u4fee\u6539\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)competingGoods.getId(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        CompetingGoods goods = (CompetingGoods)((Object)this.competingGoodsRepository.getById((Serializable)((Object)competingGoods.getId())));
        Validate.notNull((Object)((Object)goods), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u672a\u67e5\u8be2\u5230\u8981\u4fee\u6539\u7684\u6570\u636e\uff01", (Object[])new Object[0]);
        BeanUtils.copyProperties((Object)((Object)competingGoods), (Object)((Object)goods), (String[])new String[]{"id", "businessCode", "tenantCode", "delFlag", "enableStatus", "createAccount", "createTime", "createName"});
        this.updateValidate(goods);
        this.competingGoodsRepository.saveOrUpdate((Object)goods);
        return goods;
    }

    @Override
    @Transactional
    public void delete(List<String> idList) {
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u5220\u9664\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        this.competingGoodsRepository.updateDelFlagByIds(idList, DelFlagStatusEnum.DELETE);
    }

    @Override
    @Transactional
    public void enable(List<String> idList) {
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u542f\u7528\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        this.competingGoodsRepository.updateEnableStatusByIds(idList, EnableStatusEnum.ENABLE);
    }

    @Override
    @Transactional
    public void disable(List<String> idList) {
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u7981\u7528\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        this.competingGoodsRepository.updateEnableStatusByIds(idList, EnableStatusEnum.DISABLE);
    }

    private void createValidate(CompetingGoods competingGoods) {
        Validate.notNull((Object)((Object)competingGoods), (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        competingGoods.setId(null);
        competingGoods.setTenantCode(TenantUtils.getTenantCode());
        competingGoods.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        competingGoods.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        competingGoods.setBusinessCode((String)this.generateCodeService.generateCode("JP", 1).get(0));
        Validate.notBlank((CharSequence)competingGoods.getBusinessCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u4e1a\u52a1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)competingGoods.getTenantCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u79df\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)competingGoods.getGoodsBrand(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6240\u5c5e\u54c1\u724c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)competingGoods.getGoodsName(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u7ade\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)competingGoods.getGoodsSerial(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6240\u5c5e\u7cfb\u5217\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }

    private void updateValidate(CompetingGoods competingGoods) {
        Validate.notBlank((CharSequence)competingGoods.getBusinessCode(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u4e1a\u52a1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)competingGoods.getTenantCode(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u79df\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)competingGoods.getGoodsBrand(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u6240\u5c5e\u54c1\u724c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)competingGoods.getGoodsName(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u7ade\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)competingGoods.getGoodsSerial(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u6240\u5c5e\u7cfb\u5217\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }
}

