/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sfa.business.template.competing.goods.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.identity.FacturerUserDetails;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.sfa.business.template.competing.goods.local.entity.CompetingGoodsCollect;
import com.biz.crm.sfa.business.template.competing.goods.local.entity.CompetingGoodsCollectPicture;
import com.biz.crm.sfa.business.template.competing.goods.local.model.GoodsCollectInventoryModel;
import com.biz.crm.sfa.business.template.competing.goods.local.model.GoodsCollectModel;
import com.biz.crm.sfa.business.template.competing.goods.local.model.GoodsCollectPictureModel;
import com.biz.crm.sfa.business.template.competing.goods.local.repository.CompetingGoodsCollectPictureRepository;
import com.biz.crm.sfa.business.template.competing.goods.local.repository.CompetingGoodsCollectRepository;
import com.biz.crm.sfa.business.template.competing.goods.local.repository.GoodsCollectInventoryModelRepository;
import com.biz.crm.sfa.business.template.competing.goods.local.service.GoodsCollectModelService;
import com.biz.crm.sfa.business.template.competing.goods.sdk.dto.CompetingGoodsCollectPageDto;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class GoodsCollectModelServiceImpl
implements GoodsCollectModelService {
    @Autowired
    private CompetingGoodsCollectRepository goodsCollectRepository;
    @Autowired
    private CompetingGoodsCollectPictureRepository competingGoodsCollectPictureRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired
    private GoodsCollectInventoryModelRepository goodsCollectInventoryModelRepository;

    @Override
    public GoodsCollectModel findByParentCodeAndDynamicKey(String parentCode, String dynamicKey) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{parentCode, dynamicKey})) {
            return null;
        }
        CompetingGoodsCollect competingGoodsCollect = this.goodsCollectRepository.findByParentCodeAndDynamicKey(parentCode, dynamicKey);
        if (competingGoodsCollect == null) {
            return null;
        }
        GoodsCollectModel goodsCollectModel = (GoodsCollectModel)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)competingGoodsCollect, GoodsCollectModel.class, HashSet.class, ArrayList.class, new String[0]));
        this.buildGoodsCollectModel(goodsCollectModel);
        return goodsCollectModel;
    }

    @Override
    public Page<GoodsCollectModel> findByConditions(Pageable pageable, CompetingGoodsCollectPageDto dto) {
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (Objects.isNull(dto)) {
            dto = new CompetingGoodsCollectPageDto();
        }
        FacturerUserDetails loginDetails = (FacturerUserDetails)this.loginUserService.getLoginDetails(FacturerUserDetails.class);
        dto.setTenantCode(TenantUtils.getTenantCode());
        dto.setCreateAccount(loginDetails.getAccount());
        Page<CompetingGoodsCollect> byConditions = this.goodsCollectRepository.findByConditions(pageable, dto);
        List records = byConditions.getRecords();
        if (CollectionUtils.isEmpty((Collection)records)) {
            return new Page();
        }
        Set<String> collectCodes = records.stream().map(CompetingGoodsCollect::getCollectCode).collect(Collectors.toSet());
        List<GoodsCollectInventoryModel> goodsCollectInventoryModels = this.goodsCollectInventoryModelRepository.findByCollectCodes(collectCodes);
        Map<Object, Object> inventoryModelMap = new HashMap();
        if (!CollectionUtils.isEmpty(goodsCollectInventoryModels)) {
            inventoryModelMap = goodsCollectInventoryModels.stream().collect(Collectors.groupingBy(GoodsCollectInventoryModel::getCollectCode));
        }
        List goodsCollectModels = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)records, CompetingGoodsCollect.class, GoodsCollectModel.class, HashSet.class, ArrayList.class, new String[0]);
        for (GoodsCollectModel goodsCollectModel : goodsCollectModels) {
            List inventoryModels = (List)inventoryModelMap.get(goodsCollectModel.getCollectCode());
            if (CollectionUtils.isEmpty((Collection)inventoryModels)) continue;
            String band = inventoryModels.stream().map(GoodsCollectInventoryModel::getGoodsBrand).collect(Collectors.joining(","));
            goodsCollectModel.setGoodsBrandStr(band);
        }
        Page modelPage = new Page();
        BeanUtils.copyProperties(byConditions, (Object)modelPage);
        modelPage.setRecords(goodsCollectModels);
        return modelPage;
    }

    @Override
    public GoodsCollectModel findDetailsById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        CompetingGoodsCollect competingGoodsCollect = (CompetingGoodsCollect)((Object)this.goodsCollectRepository.getById((Serializable)((Object)id)));
        if (competingGoodsCollect == null) {
            return null;
        }
        GoodsCollectModel goodsCollectModel = (GoodsCollectModel)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)competingGoodsCollect, GoodsCollectModel.class, HashSet.class, ArrayList.class, new String[0]));
        this.buildGoodsCollectModel(goodsCollectModel);
        return goodsCollectModel;
    }

    private void buildGoodsCollectModel(GoodsCollectModel goodsCollectModel) {
        String collectCode = goodsCollectModel.getCollectCode();
        List<CompetingGoodsCollectPicture> competingGoodsCollectPictures = this.competingGoodsCollectPictureRepository.findByCollectCode(collectCode);
        if (!CollectionUtils.isEmpty(competingGoodsCollectPictures)) {
            List goodsCollectPictureModels = (List)this.nebulaToolkitService.copyCollectionByWhiteList(competingGoodsCollectPictures, CompetingGoodsCollectPicture.class, GoodsCollectPictureModel.class, HashSet.class, ArrayList.class, new String[0]);
            goodsCollectModel.setPictures(goodsCollectPictureModels);
        }
        List<GoodsCollectInventoryModel> goodsCollectInventoryModels = this.goodsCollectInventoryModelRepository.findByCollectCodes(Sets.newHashSet((Object[])new String[]{collectCode}));
        goodsCollectModel.setInventories(goodsCollectInventoryModels);
    }
}

