package com.biz.crm.sfa.business.template.competing.goods.sdk.dto;

import com.biz.crm.sfa.business.client.sdk.enums.ClientTypeEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * 竞品采集分页查询条件
 *
 * @author songjingen
 * @date 2022/6/8
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "CompetingGoodsCollectPageDto", description = "竞品采集分页查询条件")
public class CompetingGoodsCollectPageDto {

  private static final long serialVersionUID = -2765289943786899179L;

  /**
   * 租户编码
   */
  @ApiModelProperty("租户编码")
  private String tenantCode;


  /**
   * 采集编码
   */
  @ApiModelProperty("采集编码")
  private String collectCode;

  /**
   * 活动信息
   */
  @ApiModelProperty("活动信息")
  private String actionInfo;

  /**
   * 客户编码
   */
  @ApiModelProperty("客户编码")
  private String clientCode;

  /**
   * 客户名称
   */
  @ApiModelProperty("客户名称")
  private String clientName;

  /**
   * 客户类别
   *
   * @see ClientTypeEnum#getDictCode()
   */
  @ApiModelProperty("客户类别(经销商/终端)")
  private String clientType;

  /**
   * 提交人账号
   */
  @ApiModelProperty("提交人账号")
  private String createAccount;

  /**
   * 提交人姓名
   */
  @ApiModelProperty("提交人姓名")
  private String createName;

  /**
   * 开始时间
   */
  @ApiModelProperty("开始时间")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date createTimeStart;

  /**
   * 结束时间
   */
  @ApiModelProperty("结束时间")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date createTimeEnd;

  /**
   * 年月
   */
  @ApiModelProperty("年月")
  private String yearMonth;

  /**
   * 提交人职位编码
   */
  @ApiModelProperty("提交人职位编码")
  private String postCode;

  /**
   * 提交人职位名称
   */
  @ApiModelProperty("提交人职位名称")
  private String postName;

}
