package com.biz.crm.sfa.business.template.instore.local.models;

import com.biz.crm.common.form.sdk.field.annotation.DynamicField;
import com.biz.crm.common.form.sdk.field.annotation.Validate;
import com.biz.crm.common.form.sdk.field.validate.NotNullValidateStrategy;
import com.biz.crm.sfa.business.template.sdk.abstracts.AbstractDynamicTemplateModel;
import com.biz.crm.sfa.business.template.sdk.widget.SimpleClockUploadWidget;
import com.biz.crm.sfa.business.template.sdk.widget.SimpleLocationWidget;
import com.biz.crm.sfa.business.template.sdk.widget.SimpleStoreWidget;
import com.biz.crm.sfa.business.template.sdk.widget.SimpleUploadWidget;
import io.swagger.annotations.ApiModel;
import java.util.List;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

/**
 * @description: 进店打卡业务表单
 * @author: rentao
 * @date: 2022/6/17 11:15
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "InstoreClockModel", description = "进店打卡业务表单model")
public class InstoreClockModel extends AbstractDynamicTemplateModel {

  private static final long serialVersionUID = -7266083925810089681L;

  @DynamicField(fieldName = "定位信息", modifiable = false, validates = {@Validate(value = NotNullValidateStrategy.class)}, controllKey = SimpleLocationWidget.class)
  private LocInfoModel locInfo;

  @DynamicField(fieldName = "店铺信息", modifiable = false, validates = {@Validate(value = NotNullValidateStrategy.class)}, controllKey = SimpleStoreWidget.class)
  private StoreInfoModel storeInfo;

  @DynamicField(fieldName = "打卡照片", modifiable = false, validates = {@Validate(value = NotNullValidateStrategy.class)}, controllKey = SimpleClockUploadWidget.class)
  private List<PictureModel> pictureInfo;

}
