package com.biz.crm.sfa.business.template.instore.local.models;

import com.biz.crm.common.form.sdk.field.annotation.DynamicField;
import com.biz.crm.common.form.sdk.field.annotation.Validate;
import com.biz.crm.common.form.sdk.field.validate.NotBlankValidateStrategy;
import com.biz.crm.common.form.sdk.field.validate.NotNullValidateStrategy;
import com.biz.crm.common.form.sdk.widget.SimpleDecimalInputWidget;
import com.biz.crm.common.form.sdk.widget.SimpleInputWidget;
import io.swagger.annotations.ApiModel;
import java.math.BigDecimal;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

/**
 * @description: 店铺组件model
 * @author: rentao
 * @date: 2022/6/20 14:39
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "StoreInfoModel", description = "店铺组件model")
public class StoreInfoModel {

  @DynamicField(fieldName = "店铺编码" , modifiable = false , validates = {@Validate(value = NotBlankValidateStrategy.class)} , controllKey = SimpleInputWidget.class)
  private String storeCode;

  @DynamicField(fieldName = "店铺名称" , modifiable = false , validates = {@Validate(value = NotBlankValidateStrategy.class)} , controllKey = SimpleInputWidget.class)
  private String storeName;

  @DynamicField(fieldName = "店铺类型" , modifiable = false , validates = {@Validate(value = NotBlankValidateStrategy.class)} , controllKey = SimpleInputWidget.class)
  private String storeType;
}
