package com.biz.crm.sfa.business.template.instore.local.repository;



import com.biz.crm.sfa.business.template.instore.local.entity.InstoreClock;
import com.biz.crm.sfa.business.template.instore.local.mapper.InstoreClockMapper;
import org.springframework.beans.factory.annotation.Autowired;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.stereotype.Component;
import org.springframework.data.domain.Pageable;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import java.util.List;

/**
 * 进店打卡(InstoreClock)Repository
 *
 * @author rentao
 * @since 2022-06-16 16:34:15
 */
@Component
public class InstoreClockRepository extends ServiceImpl<InstoreClockMapper, InstoreClock> {

  @Autowired
  private InstoreClockMapper instoreClockMapper;

  /**
   * 分页查询
   *
   * @param pageable 分页参数
   * @param instoreClock 分页条件
   * @return
   */
  public Page<InstoreClock> findByConditions(Pageable pageable, InstoreClock instoreClock) {
    Page<InstoreClock> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    Page<InstoreClock> pageList = this.instoreClockMapper.findByConditions(page, instoreClock);
    return pageList;
  }

  /**
   * 删除
   *
   * @param parentCode
   * @param dynamicKey
   * @return
   */
  public void deleteByParentCodeAndDynamicKey(String parentCode, String dynamicKey){
    this.lambdaUpdate().eq(InstoreClock::getParentCode,parentCode)
        .eq(InstoreClock::getDynamicKey,dynamicKey)
        .remove();
  }

  /**
   * 进店打卡单个查询
   *
   * @param parentCode
   * @param dynamicKey
   * @return
   */
  public InstoreClock findByParentCodeAndDynamicKey(String parentCode, String dynamicKey){
    return this.lambdaQuery().eq(InstoreClock::getParentCode,parentCode)
        .eq(InstoreClock::getDynamicKey,dynamicKey)
        .one();
  }
}

