package com.biz.crm.sfa.business.template.instore.local.service.internal;

import com.biz.crm.business.common.sdk.model.LoginUserDetails;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.sfa.business.template.instore.local.repository.InstoreClockRepository;
import com.biz.crm.sfa.business.template.instore.local.entity.InstoreClock;
import com.biz.crm.sfa.business.template.instore.local.service.InstoreClockService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.springframework.stereotype.Service;
import org.springframework.beans.factory.annotation.Autowired;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.data.domain.Pageable;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.transaction.annotation.Transactional;
import java.util.Objects;

/**
 * 进店打卡(InstoreClock)serviceImpl
 *
 * @author rentao
 * @since 2022-06-16 16:34:04
 */
@Service("instoreClockService")
public class InstoreClockServiceImpl implements InstoreClockService {

  @Autowired private InstoreClockRepository instoreClockRepository;
  @Autowired private LoginUserService loginUserService;

  /**
   * 分页查询
   *
   * @param pageable 分页参数
   * @param instoreClock 分页条件
   * @return
   */
  @Override
  public Page<InstoreClock> findByConditions(Pageable pageable, InstoreClock instoreClock) {
    ObjectUtils.defaultIfNull(pageable, PageRequest.of(0, 50));
    if (Objects.isNull(instoreClock)) {
      instoreClock = new InstoreClock();
    }
    return this.instoreClockRepository.findByConditions(pageable, instoreClock);
  }

  /**
   * ͨid查询详情
   *
   * @param id id主键
   */
  @Override
  public InstoreClock findById(String id) {
    if (StringUtils.isBlank(id)) {
      return null;
    }
    return this.instoreClockRepository.getById(id);
  }

  /**
   * 新增
   *
   * @param instoreClock 新增参数
   * @return
   */
  @Transactional
  @Override
  public InstoreClock create(InstoreClock instoreClock) {
    this.createValidate(instoreClock);
    this.instoreClockRepository.saveOrUpdate(instoreClock);
    return instoreClock;
  }

  /**
   * 编辑
   *
   * @param instoreClock 编辑参数
   * @return
   */
  @Transactional
  @Override
  public InstoreClock update(InstoreClock instoreClock) {
    this.updateValidate(instoreClock);
    this.instoreClockRepository.saveOrUpdate(instoreClock);
    return instoreClock;
  }

  /**
   * 删除
   *
   * @param parentCode
   * @param dynamicKey
   * @return
   */
  @Override
  @Transactional
  public void deleteByParentCodeAndDynamicKey(String parentCode, String dynamicKey) {
    this.instoreClockRepository.deleteByParentCodeAndDynamicKey(parentCode,dynamicKey);
  }

  /**
   * 进店打卡单个查询
   *
   * @param parentCode
   * @param dynamicKey
   * @return
   */
  @Override
  public InstoreClock findByParentCodeAndDynamicKey(String parentCode, String dynamicKey) {
    return this.instoreClockRepository.findByParentCodeAndDynamicKey(parentCode,dynamicKey);
  }

  /**
   * 新增验证
   *
   * @param instoreClock
   */
  private void createValidate(InstoreClock instoreClock) {
    Validate.notNull(instoreClock, "新增信息时，传入参数不能为空");
    instoreClock.setId(null);
    Validate.notBlank(instoreClock.getClockPlace(), "新增信息时，打卡地点不能为空");
    Validate.notBlank(instoreClock.getStoreCode(), "新增信息时，店铺编码不能为空");
    Validate.notBlank(instoreClock.getStoreName(), "新增信息时，店铺名称不能为空");
    instoreClock.setTenantCode(TenantUtils.getTenantCode());
    LoginUserDetails loginDetails = this.loginUserService.getLoginDetails(LoginUserDetails.class);
    instoreClock.setCreatePosCode(loginDetails.getPostCode());
    instoreClock.setCreatePosName(loginDetails.getPostName());
    instoreClock.setCreateOrgCode(loginDetails.getOrgCode());
    instoreClock.setCreateOrgName(loginDetails.getOrgName());
  }

  /**
   * 编辑验证
   *
   * @param instoreClock
   */
  private void updateValidate(InstoreClock instoreClock) {
    Validate.notNull(instoreClock, "修改信息时，传入参数不能为空");
    Validate.notBlank(instoreClock.getId(), "修改信息时，主键不能为空");
    Validate.notBlank(instoreClock.getClockPlace(), "修改信息时，打卡地点不能为空");
    Validate.notBlank(instoreClock.getStoreCode(), "修改信息时，店铺编码不能为空");
    Validate.notBlank(instoreClock.getStoreName(), "修改信息时，店铺名称不能为空");
    instoreClock.setTenantCode(TenantUtils.getTenantCode());
  }
}
