/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sfa.business.template.instore.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.LoginUserDetails;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.sfa.business.template.instore.local.entity.InstoreClock;
import com.biz.crm.sfa.business.template.instore.local.repository.InstoreClockRepository;
import com.biz.crm.sfa.business.template.instore.local.service.InstoreClockService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.io.Serializable;
import java.util.Objects;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="instoreClockService")
public class InstoreClockServiceImpl
implements InstoreClockService {
    @Autowired
    private InstoreClockRepository instoreClockRepository;
    @Autowired
    private LoginUserService loginUserService;

    @Override
    public Page<InstoreClock> findByConditions(Pageable pageable, InstoreClock instoreClock) {
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (Objects.isNull((Object)instoreClock)) {
            instoreClock = new InstoreClock();
        }
        return this.instoreClockRepository.findByConditions(pageable, instoreClock);
    }

    @Override
    public InstoreClock findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return (InstoreClock)((Object)this.instoreClockRepository.getById((Serializable)((Object)id)));
    }

    @Override
    @Transactional
    public InstoreClock create(InstoreClock instoreClock) {
        this.createValidate(instoreClock);
        this.instoreClockRepository.saveOrUpdate((Object)instoreClock);
        return instoreClock;
    }

    @Override
    @Transactional
    public InstoreClock update(InstoreClock instoreClock) {
        this.updateValidate(instoreClock);
        this.instoreClockRepository.saveOrUpdate((Object)instoreClock);
        return instoreClock;
    }

    @Override
    @Transactional
    public void deleteByParentCodeAndDynamicKey(String parentCode, String dynamicKey) {
        this.instoreClockRepository.deleteByParentCodeAndDynamicKey(parentCode, dynamicKey);
    }

    @Override
    public InstoreClock findByParentCodeAndDynamicKey(String parentCode, String dynamicKey) {
        return this.instoreClockRepository.findByParentCodeAndDynamicKey(parentCode, dynamicKey);
    }

    private void createValidate(InstoreClock instoreClock) {
        Validate.notNull((Object)((Object)instoreClock), (String)"\u65b0\u589e\u4fe1\u606f\u65f6\uff0c\u4f20\u5165\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        instoreClock.setId(null);
        Validate.notBlank((CharSequence)instoreClock.getClockPlace(), (String)"\u65b0\u589e\u4fe1\u606f\u65f6\uff0c\u6253\u5361\u5730\u70b9\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)instoreClock.getStoreCode(), (String)"\u65b0\u589e\u4fe1\u606f\u65f6\uff0c\u5e97\u94fa\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)instoreClock.getStoreName(), (String)"\u65b0\u589e\u4fe1\u606f\u65f6\uff0c\u5e97\u94fa\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        instoreClock.setTenantCode(TenantUtils.getTenantCode());
        LoginUserDetails loginDetails = (LoginUserDetails)this.loginUserService.getLoginDetails(LoginUserDetails.class);
        instoreClock.setCreatePosCode(loginDetails.getPostCode());
        instoreClock.setCreatePosName(loginDetails.getPostName());
        instoreClock.setCreateOrgCode(loginDetails.getOrgCode());
        instoreClock.setCreateOrgName(loginDetails.getOrgName());
    }

    private void updateValidate(InstoreClock instoreClock) {
        Validate.notNull((Object)((Object)instoreClock), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u4f20\u5165\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)instoreClock.getId(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)instoreClock.getClockPlace(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u6253\u5361\u5730\u70b9\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)instoreClock.getStoreCode(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u5e97\u94fa\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)instoreClock.getStoreName(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u5e97\u94fa\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        instoreClock.setTenantCode(TenantUtils.getTenantCode());
    }
}

