/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sfa.business.template.instore.local.strategy;

import com.biz.crm.common.form.sdk.model.DynamicFormOperationStrategy;
import com.biz.crm.sfa.business.step.sdk.register.StepFormModuleRegister;
import com.biz.crm.sfa.business.template.instore.local.entity.InstoreClock;
import com.biz.crm.sfa.business.template.instore.local.models.InstoreClockModel;
import com.biz.crm.sfa.business.template.instore.local.models.LocInfoModel;
import com.biz.crm.sfa.business.template.instore.local.models.PictureModel;
import com.biz.crm.sfa.business.template.instore.local.models.StoreInfoModel;
import com.biz.crm.sfa.business.template.instore.local.service.InstoreClockService;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Component
public class DynamicFormOperationStrategyInstoreClockModule
implements DynamicFormOperationStrategy<InstoreClockModel> {
    @Autowired
    private StepFormModuleRegister stepFormModuleRegister;
    @Autowired
    private InstoreClockService instoreClockService;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    private static final Logger LOGGER = LoggerFactory.getLogger(DynamicFormOperationStrategyInstoreClockModule.class);

    public int getOrder() {
        return 10;
    }

    public String dynamicFormCode() {
        return StringUtils.uncapitalize((String)this.getClass().getSimpleName());
    }

    public String dynamicFormName() {
        return "\u8fdb\u5e97\u6253\u5361";
    }

    public Class<InstoreClockModel> dynamicFormClass() {
        return InstoreClockModel.class;
    }

    public String moduleCode() {
        return this.stepFormModuleRegister.moduleCode();
    }

    @Transactional
    public void onDynamicFormsDelete(String parentCode, String dynamicKey) {
        LOGGER.info("onDynamicFormsDelete(String parentCode, String dynamicKey)");
        LOGGER.info("onDynamicFormsDelete(String parentCode, String dynamicKey)");
        this.instoreClockService.deleteByParentCodeAndDynamicKey(parentCode, dynamicKey);
    }

    @Transactional
    public void onDynamicFormCreate(InstoreClockModel dynamicForm, String dynamicKey, String parentCode, Object parent) {
        dynamicForm.setParentCode(parentCode);
        dynamicForm.setDynamicKey(dynamicKey);
        LOGGER.info("onDynamicFormCreate(CpuAccessory dynamicForm, String dynamicKey, String parentCode,Object parent)");
        InstoreClock instoreClock = (InstoreClock)((Object)this.nebulaToolkitService.copyObjectByBlankList((Object)dynamicForm, InstoreClock.class, HashSet.class, ArrayList.class, new String[0]));
        this.validateCreateOrUpdate(dynamicForm);
        this.transitionToInstoreClock(instoreClock, dynamicForm);
        InstoreClockModel instoreClockModel = this.findByParentCode(dynamicKey, parentCode);
        Validate.isTrue((boolean)Objects.isNull((Object)instoreClockModel), (String)"\u8fdb\u5e97\u6253\u5361\u6570\u636e\u5df2\u5b58\u5728\uff01", (Object[])new Object[0]);
        this.instoreClockService.create(instoreClock);
    }

    @Transactional
    public void onDynamicFormModify(InstoreClockModel dynamicForm, String dynamicKey, String parentCode, Object parent) {
        dynamicForm.setParentCode(parentCode);
        dynamicForm.setDynamicKey(dynamicKey);
        LOGGER.info("onDynamicFormModify(CpuAccessory dynamicForm, String dynamicKey, String parentCode, Object parent)");
        InstoreClock instoreClock = (InstoreClock)((Object)this.nebulaToolkitService.copyObjectByBlankList((Object)dynamicForm, InstoreClock.class, HashSet.class, ArrayList.class, new String[0]));
        this.validateCreateOrUpdate(dynamicForm);
        this.transitionToInstoreClock(instoreClock, dynamicForm);
        this.instoreClockService.update(instoreClock);
    }

    public InstoreClockModel findByParentCode(String dynamicKey, String parentCode) {
        LOGGER.info("findByParentCode(String dynamicKey(" + dynamicKey + "), String parentCode[" + parentCode + "])");
        InstoreClock instoreClock = this.instoreClockService.findByParentCodeAndDynamicKey(parentCode, dynamicKey);
        if (Objects.isNull((Object)instoreClock)) {
            return null;
        }
        InstoreClockModel instoreClockModel = (InstoreClockModel)((Object)this.nebulaToolkitService.copyObjectByBlankList((Object)instoreClock, InstoreClockModel.class, HashSet.class, ArrayList.class, new String[0]));
        this.transitionToInstoreClockModel(instoreClock, instoreClockModel);
        return instoreClockModel;
    }

    private void transitionToInstoreClock(InstoreClock instoreClock, InstoreClockModel dynamicForm) {
        LocInfoModel locInfo = dynamicForm.getLocInfo();
        StoreInfoModel storeInfo = dynamicForm.getStoreInfo();
        List<PictureModel> pictureInfo = dynamicForm.getPictureInfo();
        if (!CollectionUtils.isEmpty(pictureInfo)) {
            instoreClock.setPictureUrl(pictureInfo.get(0).getPictureUrl());
        }
        if (Objects.nonNull(storeInfo)) {
            instoreClock.setClockPlace(locInfo.getClockPlace());
            instoreClock.setClockLongitude(locInfo.getClockLongitude());
            instoreClock.setClockLatitude(locInfo.getClockLatitude());
        }
        instoreClock.setStoreCode(storeInfo.getStoreCode());
        instoreClock.setStoreName(storeInfo.getStoreName());
    }

    private void transitionToInstoreClockModel(InstoreClock instoreClock, InstoreClockModel dynamicForm) {
        LocInfoModel locInfo = new LocInfoModel();
        StoreInfoModel storeInfo = new StoreInfoModel();
        PictureModel pictureInfo = new PictureModel();
        locInfo.setClockPlace(instoreClock.getClockPlace());
        locInfo.setClockLongitude(instoreClock.getClockLongitude());
        locInfo.setClockLatitude(instoreClock.getClockLatitude());
        storeInfo.setStoreCode(instoreClock.getStoreCode());
        storeInfo.setStoreName(instoreClock.getStoreName());
        pictureInfo.setPictureUrl(instoreClock.getPictureUrl());
        dynamicForm.setLocInfo(locInfo);
        dynamicForm.setStoreInfo(storeInfo);
        dynamicForm.setPictureInfo(Collections.singletonList(pictureInfo));
    }

    private void validateCreateOrUpdate(InstoreClockModel dynamicForm) {
        Validate.notNull((Object)dynamicForm.getStoreInfo(), (String)"\u8fdb\u5e97\u6253\u5361\u5e97\u94fa\u6570\u636e\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dynamicForm.getStoreInfo().getStoreCode(), (String)"\u8fdb\u5e97\u6253\u5361\u5e97\u94fa\u7f16\u7801\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dynamicForm.getStoreInfo().getStoreName(), (String)"\u8fdb\u5e97\u6253\u5361\u5e97\u94fa\u540d\u79f0\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dynamicForm.getStoreInfo().getStoreType(), (String)"\u8fdb\u5e97\u6253\u5361\u5e97\u94fa\u7c7b\u578b\u4e0d\u5b58\u5728", (Object[])new Object[0]);
    }
}

