package com.biz.crm.sfa.business.template.instore.local.service;


import com.biz.crm.sfa.business.template.instore.local.entity.InstoreClock;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.data.domain.Pageable;
import java.util.List;

/**
 * 进店打卡(InstoreClock)service
 *
 * @author rentao
 * @since 2022-06-16 16:34:04
 */
public interface InstoreClockService{

  /**
   * 分页查询
   *
   * @param pageable 分页参数
   * @param instoreClock 分页条件
   * @return
   */
  Page<InstoreClock> findByConditions(Pageable pageable, InstoreClock instoreClock);

  /**
   * ͨid查询详情
   *
   * @param id id主键
   *
   */
  InstoreClock findById(String id);

  /**
   * 新增
   *
   * @param instoreClock 新增参数
   * @return
   */
  InstoreClock create(InstoreClock instoreClock);

  /**
   * 编辑
   *
   * @param instoreClock 编辑参数
   * @return
   */
  InstoreClock update(InstoreClock instoreClock);

  /**
   * 删除
   *
   * @param parentCode
   * @param dynamicKey
   * @return
   */
  void deleteByParentCodeAndDynamicKey(String parentCode,String dynamicKey);

  /**
   * 进店打卡单个查询
   *
   * @param parentCode
   * @param dynamicKey
   * @return
   */
  InstoreClock findByParentCodeAndDynamicKey(String parentCode,String dynamicKey);

}

