package com.biz.crm.sfa.business.template.instore.local.strategy;

import com.biz.crm.common.form.sdk.model.DynamicFormOperationStrategy;
import com.biz.crm.sfa.business.step.sdk.register.StepFormModuleRegister;
import com.biz.crm.sfa.business.template.instore.local.entity.InstoreClock;
import com.biz.crm.sfa.business.template.instore.local.models.InstoreClockModel;
import com.biz.crm.sfa.business.template.instore.local.models.LocInfoModel;
import com.biz.crm.sfa.business.template.instore.local.models.PictureModel;
import com.biz.crm.sfa.business.template.instore.local.models.StoreInfoModel;
import com.biz.crm.sfa.business.template.instore.local.service.InstoreClockService;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;

/**
 * @description: 进店打卡
 * @author: rentao
 * @date: 2022/6/17 14:33
 */
@Component
public class DynamicFormOperationStrategyInstoreClockModule
    implements DynamicFormOperationStrategy<InstoreClockModel> {

  @Autowired
  private StepFormModuleRegister stepFormModuleRegister;
  @Autowired
  private InstoreClockService instoreClockService;
  @Autowired
  private NebulaToolkitService nebulaToolkitService;

  /**
   * 日志
   */
  private static final Logger LOGGER =
      LoggerFactory.getLogger(DynamicFormOperationStrategyInstoreClockModule.class);

  @Override
  public int getOrder() {
    return 10;
  }

  @Override
  public String dynamicFormCode() {
    return StringUtils.uncapitalize(this.getClass().getSimpleName());
  }

  @Override
  public String dynamicFormName() {
    return "进店打卡";
  }

  @Override
  public Class<InstoreClockModel> dynamicFormClass() {
    return InstoreClockModel.class;
  }

  @Override
  public String moduleCode() {
    return this.stepFormModuleRegister.moduleCode();
  }

  @Override
  @Transactional
  public void onDynamicFormsDelete(String parentCode, String dynamicKey) {
    LOGGER.info("onDynamicFormsDelete(String parentCode, String dynamicKey)");
    LOGGER.info("onDynamicFormsDelete(String parentCode, String dynamicKey)");
    this.instoreClockService.deleteByParentCodeAndDynamicKey(parentCode, dynamicKey);
  }

  @Override
  @Transactional
  public void onDynamicFormCreate(
      InstoreClockModel dynamicForm, String dynamicKey, String parentCode, Object parent) {
    dynamicForm.setParentCode(parentCode);
    dynamicForm.setDynamicKey(dynamicKey);
    LOGGER.info(
        "onDynamicFormCreate(CpuAccessory dynamicForm, String dynamicKey, String parentCode,Object parent)");
    InstoreClock instoreClock =
        this.nebulaToolkitService.copyObjectByBlankList(
            dynamicForm, InstoreClock.class, HashSet.class, ArrayList.class);
    this.validateCreateOrUpdate(dynamicForm);
    this.transitionToInstoreClock(instoreClock, dynamicForm);
    InstoreClockModel instoreClockModel = this.findByParentCode(dynamicKey, parentCode);
    Validate.isTrue(Objects.isNull(instoreClockModel), "进店打卡数据已存在！");
    this.instoreClockService.create(instoreClock);
  }

  @Override
  @Transactional
  public void onDynamicFormModify(
      InstoreClockModel dynamicForm, String dynamicKey, String parentCode, Object parent) {
    dynamicForm.setParentCode(parentCode);
    dynamicForm.setDynamicKey(dynamicKey);
    LOGGER.info(
        "onDynamicFormModify(CpuAccessory dynamicForm, String dynamicKey, String parentCode, Object parent)");
    InstoreClock instoreClock =
        this.nebulaToolkitService.copyObjectByBlankList(
            dynamicForm, InstoreClock.class, HashSet.class, ArrayList.class);
    this.validateCreateOrUpdate(dynamicForm);
    this.transitionToInstoreClock(instoreClock, dynamicForm);
    this.instoreClockService.update(instoreClock);
  }

  @Override
  public InstoreClockModel findByParentCode(String dynamicKey, String parentCode) {
    LOGGER.info(
        "findByParentCode(String dynamicKey("
            + dynamicKey
            + "), String parentCode["
            + parentCode
            + "])");
    InstoreClock instoreClock =
        this.instoreClockService.findByParentCodeAndDynamicKey(parentCode, dynamicKey);
    if (Objects.isNull(instoreClock)) {
      return null;
    }
    InstoreClockModel instoreClockModel =
        this.nebulaToolkitService.copyObjectByBlankList(
            instoreClock, InstoreClockModel.class, HashSet.class, ArrayList.class);
    this.transitionToInstoreClockModel(instoreClock, instoreClockModel);
    return instoreClockModel;
  }

  /*
   *
   * 转实体
   * @param instoreClock
   * @param dynamicForm
   * @author rentao
   * @date a
   */
  private void transitionToInstoreClock(InstoreClock instoreClock, InstoreClockModel dynamicForm) {
    LocInfoModel locInfo = dynamicForm.getLocInfo();
    StoreInfoModel storeInfo = dynamicForm.getStoreInfo();
    List<PictureModel> pictureInfo = dynamicForm.getPictureInfo();
    if (!CollectionUtils.isEmpty(pictureInfo)) {
      instoreClock.setFileCode(pictureInfo.get(0).getFileCode());
      instoreClock.setOriginalFileName(pictureInfo.get(0).getOriginalFileName());
    }
    if (Objects.nonNull(storeInfo)) {
      instoreClock.setClockPlace(locInfo.getClockPlace());
      instoreClock.setClockLongitude(locInfo.getClockLongitude());
      instoreClock.setClockLatitude(locInfo.getClockLatitude());
    }
    instoreClock.setStoreCode(storeInfo.getStoreCode());
    instoreClock.setStoreName(storeInfo.getStoreName());
  }

  /*
   *
   * 转模型
   * @param instoreClock
   * @param dynamicForm
   * @author rentao
   * @date a
   */
  private void transitionToInstoreClockModel(
      InstoreClock instoreClock, InstoreClockModel dynamicForm) {
    LocInfoModel locInfo = new LocInfoModel();
    StoreInfoModel storeInfo = new StoreInfoModel();
    PictureModel pictureInfo = new PictureModel();
    locInfo.setClockPlace(instoreClock.getClockPlace());
    locInfo.setClockLongitude(instoreClock.getClockLongitude());
    locInfo.setClockLatitude(instoreClock.getClockLatitude());
    storeInfo.setStoreCode(instoreClock.getStoreCode());
    storeInfo.setStoreName(instoreClock.getStoreName());
    pictureInfo.setFileCode(instoreClock.getFileCode());
    pictureInfo.setOriginalFileName(instoreClock.getOriginalFileName());

    dynamicForm.setLocInfo(locInfo);
    dynamicForm.setStoreInfo(storeInfo);
    dynamicForm.setPictureInfo(Collections.singletonList(pictureInfo));
  }

  private void validateCreateOrUpdate(InstoreClockModel dynamicForm) {
    Validate.notNull(dynamicForm.getStoreInfo(), "进店打卡店铺数据不存在");
    Validate.notBlank(dynamicForm.getStoreInfo().getStoreCode(), "进店打卡店铺编码不存在");
    Validate.notBlank(dynamicForm.getStoreInfo().getStoreName(), "进店打卡店铺名称不存在");
    Validate.notBlank(dynamicForm.getStoreInfo().getStoreType(), "进店打卡店铺类型不存在");
  }
}
