package com.biz.crm.sfa.business.template.instore.local.strategy;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.sfa.business.template.instore.local.models.InstoreClockModel;
import com.biz.crm.sfa.business.template.sdk.abstracts.AbstractDynamicTemplateModel;
import com.biz.crm.sfa.business.template.sdk.strategy.DynamicTemplateOperationStrategy;
import com.bizunited.nebula.common.util.JsonUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

/**
 * @description: 进店打卡表单模板操作策略实现类
 * @author: rentao
 * @date: 2022/6/23 10:30
 */
@Component
public class DynamicTemplateOperationStrategyInstoreClockModule implements DynamicTemplateOperationStrategy {

  @Autowired
  private DynamicFormOperationStrategyInstoreClockModule dynamicFormOperationStrategyInstoreClockModule;

  @Override
  public String dynamicFormCode() {
    return this.dynamicFormOperationStrategyInstoreClockModule.dynamicFormCode();
  }

  @Override
  @Transactional
  public void onDynamicTemplateCreate(JSONObject jsonObject, String dynamicKey, String parentCode) {
    InstoreClockModel instoreClockModel = JsonUtils
        .json2Obj(jsonObject.toJSONString(), InstoreClockModel.class);
    this.dynamicFormOperationStrategyInstoreClockModule.onDynamicFormCreate(instoreClockModel, dynamicKey, parentCode, null);
  }

  @Override
  @Transactional
  public void onDynamicTemplateModify(JSONObject jsonObject, String dynamicKey, String parentCode) {
    InstoreClockModel goodsCollectModel = JsonUtils.json2Obj(jsonObject.toJSONString(), InstoreClockModel.class);
    this.dynamicFormOperationStrategyInstoreClockModule.onDynamicFormModify(goodsCollectModel, dynamicKey, parentCode, null);
  }


  @Override
  public AbstractDynamicTemplateModel findByParentCode(String dynamicKey, String parentCode) {
    return this.dynamicFormOperationStrategyInstoreClockModule.findByParentCode(dynamicKey, parentCode);
  }
}
