package com.biz.crm.sfa.business.inventory.check.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.sfa.business.template.sdk.abstracts.AbstractDynamicTemplateEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Transient;
import java.math.BigDecimal;
import java.util.List;

/**
 * 库存盘点实体类
 *
 * @author jerry7
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "InventoryCheckEntity", description = "库存盘点实体类")
@Entity
@TableName("sfa_inventory_check")
@Table(name = "sfa_inventory_check")
@org.hibernate.annotations.Table(appliesTo = "sfa_inventory_check", comment = "库存盘点表")
public class InventoryCheckEntity extends AbstractDynamicTemplateEntity {

  private static final long serialVersionUID = -8718203111224722645L;
  /**
   * 站点编码
   */
  @Column(name = "client_code", length = 64, columnDefinition = "VARCHAR(64) NOT NULL COMMENT '站点编码'")
  @ApiModelProperty("站点编码")
  private String clientCode;

  /**
   * 站点名称
   */
  @Column(name = "client_name", length = 64, columnDefinition = "VARCHAR(64) NOT NULL COMMENT '站点名称'")
  @ApiModelProperty("站点名称")
  private String clientName;

  /**
   * 站点类别
   */
  @Column(name = "client_type", length = 32, columnDefinition = "VARCHAR(32) NOT NULL COMMENT '站点类别(经销商/终端)'")
  @ApiModelProperty("站点类别(经销商/终端)")
  private String clientType;

  /**
   * 位置信息：经度
   */
  @Column(name = "longitude", columnDefinition = "decimal(12,8) COMMENT '经度'")
  @ApiModelProperty("位置信息:经度")
  private BigDecimal longitude;

  /**
   * 位置信息：纬度
   */
  @Column(name = "latitude", columnDefinition = "decimal(12,8) COMMENT '纬度'")
  @ApiModelProperty("位置信息:纬度")
  private BigDecimal latitude;

  /**
   * 位置信息
   */
  @Column(name = "check_address", length = 128, columnDefinition = "VARCHAR(128) COMMENT '位置信息'")
  @ApiModelProperty("位置信息")
  private String checkAddress;

  /**
   * 产品层级数量
   */
  @Column(name = "product_level_quantify", length = 3, columnDefinition = "int(3) NOT NULL COMMENT '产品层级数量'")
  @ApiModelProperty("产品层级数量")
  private String productLevelQuantify;

  /**
   * 商品种类数量
   */
  @Column(name = "product_type_quantify", length = 3, columnDefinition = "int(3) NOT NULL COMMENT '商品种类数量'")
  @ApiModelProperty("商品种类数量")
  private String productTypeQuantify;

  /**
   * 商品数量
   */
  @Column(name = "product_quantify", length = 9, columnDefinition = "int(9) NOT NULL COMMENT '商品数量'")
  @ApiModelProperty("商品数量")
  private String productQuantify;

  /**
   * 用户姓名
   */
  @Column(name = "user_name", columnDefinition = "VARCHAR(64) NOT NULL COMMENT '用户姓名'")
  @ApiModelProperty("用户姓名")
  private String userName;

  /**
   * 用户编码
   */
  @Column(name = "user_code", columnDefinition = "VARCHAR(64) NOT NULL COMMENT '用户编码'")
  @ApiModelProperty("用户编码")
  private String userCode;

  /**
   * 职位编码
   */
  @Column(name = "post_code", columnDefinition = "VARCHAR(64) NOT NULL COMMENT '职位编码'")
  @ApiModelProperty("职位编码")
  private String postCode;

  /**
   * 职位名称
   */
  @Column(name = "post_name", columnDefinition = "VARCHAR(64) NOT NULL COMMENT '职位名称'")
  @ApiModelProperty("职位名称")
  private String postName;

  /**
   * 组织编码
   */
  @Column(name = "org_code", columnDefinition = "VARCHAR(64) NOT NULL COMMENT '组织编码'")
  @ApiModelProperty("组织编码")
  private String orgCode;

  /**
   * 组织名称
   */
  @Column(name = "org_name", columnDefinition = "VARCHAR(64) NOT NULL COMMENT '组织名称'")
  @ApiModelProperty("组织名称")
  private String orgName;

  /**
   * 库存盘点详情列表
   */
  @Transient
  @TableField(exist = false)
  @ApiModelProperty("库存盘点详情列表")
  private List<InventoryCheckDetailEntity> details;

}
