package com.biz.crm.sfa.business.inventory.check.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.sfa.business.inventory.check.local.entity.InventoryCheckEntity;
import org.apache.ibatis.annotations.Param;
import org.springframework.data.domain.Pageable;

/**
 * 库存盘点mapper
 * @author jerry7
 */
public interface InventoryCheckMapper extends BaseMapper<InventoryCheckEntity> {

  /**
   * 分页查询库存盘点列表
   * @param page 分页信息
   * @param dto 查询参数
   * @return 库存盘点列表
   */
  Page<InventoryCheckEntity> findByConditions(Page<InventoryCheckEntity> page, @Param("dto") InventoryCheckEntity dto);
}
