package com.biz.crm.sfa.business.inventory.check.local.model;


import com.biz.crm.common.form.sdk.field.annotation.DynamicField;
import com.biz.crm.common.form.sdk.field.annotation.Validate;
import com.biz.crm.common.form.sdk.field.validate.NotBlankValidateStrategy;
import com.biz.crm.sfa.business.template.sdk.abstracts.AbstractDynamicTemplateModel;
import com.biz.crm.sfa.business.template.sdk.widget.SimpleInventoryWidget;
import com.biz.crm.sfa.business.template.sdk.widget.SimpleNotShowWidget;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import java.util.List;

/**
 * 库存盘点Model
 *
 * @author jerry7
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "InventoryCheckModel", description = "库存盘点Model")
public class InventoryCheckModel extends AbstractDynamicTemplateModel {

  /**
   * 站点名称
   */
  @DynamicField(fieldName = "站点名称", validates = {@Validate(value = NotBlankValidateStrategy.class)}, controllKey = SimpleNotShowWidget.class)
  @ApiModelProperty("站点名称")
  private String clientName;

  /**
   * 位置信息
   */
  @DynamicField(fieldName = "位置信息", validates = {@Validate(value = NotBlankValidateStrategy.class)}, controllKey = SimpleNotShowWidget.class)
  @ApiModelProperty("位置信息")
  private String checkAddress;

  /**
   * 产品层级数量
   */
  @DynamicField(fieldName = "产品层级数量", validates = {@Validate(value = NotBlankValidateStrategy.class)}, controllKey = SimpleNotShowWidget.class)
  @ApiModelProperty("产品层级数量")
  private String productLevelQuantify;

  /**
   * 商品种类数量
   */
  @DynamicField(fieldName = "商品种类数量", validates = {@Validate(value = NotBlankValidateStrategy.class)}, controllKey = SimpleNotShowWidget.class)
  @ApiModelProperty("商品种类数量")
  private String productTypeQuantify;

  /**
   * 商品数量
   */
  @DynamicField(fieldName = "商品数量", validates = {@Validate(value = NotBlankValidateStrategy.class)}, controllKey = SimpleNotShowWidget.class)
  @ApiModelProperty("商品数量")
  private String productQuantify;

  /**
   * 用户姓名
   */
  @DynamicField(fieldName = "用户姓名", validates = {@Validate(value = NotBlankValidateStrategy.class)}, controllKey = SimpleNotShowWidget.class)
  @ApiModelProperty("用户姓名")
  private String userName;

  /**
   * 用户编码
   */
  @DynamicField(fieldName = "用户编码", validates = {@Validate(value = NotBlankValidateStrategy.class)}, controllKey = SimpleNotShowWidget.class)
  @ApiModelProperty("用户编码")
  private String userCode;

  /**
   * 职位编码
   */
  @DynamicField(fieldName = "职位编码", validates = {@Validate(value = NotBlankValidateStrategy.class)}, controllKey = SimpleNotShowWidget.class)
  @ApiModelProperty("职位编码")
  private String postCode;

  /**
   * 职位名称
   */
  @DynamicField(fieldName = "职位名称", validates = {@Validate(value = NotBlankValidateStrategy.class)}, controllKey = SimpleNotShowWidget.class)
  @ApiModelProperty("职位名称")
  private String postName;

  /**
   * 盘库按钮
   */
  @DynamicField(fieldName = "盘库按钮", validates = {@Validate(value = NotBlankValidateStrategy.class)}, controllKey = SimpleInventoryWidget.class, required = false)
  @ApiModelProperty("盘库按钮")
  private String inventoryButton;

  /**
   * 盘库详情列表
   */
  @ApiModelProperty("盘库详情列表")
  @DynamicField(fieldName = "盘库详情列表", validates = {@Validate(value = NotBlankValidateStrategy.class)}, controllKey = SimpleNotShowWidget.class)
  private List<InventoryCheckDetailModel> details;

}
