package com.biz.crm.sfa.business.inventory.check.local.service;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.sfa.business.inventory.check.local.entity.InventoryCheckEntity;
import org.springframework.data.domain.Pageable;

/**
 * 库存盘点接口
 */
public interface InventoryCheckService {

  /**
   * 创建库存盘点
   *
   * @param inventoryCheckEntity 库存盘点实体
   * @return 创建结果
   */
  InventoryCheckEntity create(InventoryCheckEntity inventoryCheckEntity);

  /**
   * 更新库存盘点
   *
   * @param inventoryCheckEntity 库存盘点实体
   * @return 更新结果
   */
  InventoryCheckEntity update(InventoryCheckEntity inventoryCheckEntity);

  /**
   * 分页查询库存盘点列表
   *
   * @param pageable             分页信息
   * @param inventoryCheckEntity 查询参数
   * @return 库存盘点列表
   */
  Page<InventoryCheckEntity> findByConditions(Pageable pageable, InventoryCheckEntity inventoryCheckEntity);

  /**
   * 根据id查询库存盘点详情
   *
   * @param id id
   * @return 库存盘点详情
   */
  InventoryCheckEntity findDetailById(String id);

  /**
   * 根据客户查看库存盘点最后一条记录
   *
   * @param clientCode 客户编码
   * @param clientType 客户类型
   * @return 库存盘点列表
   */
  InventoryCheckEntity findLatestByClientTypeAndClientCode(String clientType, String clientCode);
}
