package com.biz.crm.sfa.business.inventory.check.local.service.internal;

import com.biz.crm.sfa.business.inventory.check.local.entity.InventoryCheckEntity;
import com.biz.crm.sfa.business.inventory.check.local.model.InventoryCheckModel;
import com.biz.crm.sfa.business.inventory.check.local.repository.InventoryCheckDetailRepository;
import com.biz.crm.sfa.business.inventory.check.local.repository.InventoryCheckRepository;
import com.biz.crm.sfa.business.inventory.check.local.service.InventoryCheckModelService;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashSet;

/**
 * 库存盘点model接口实现
 */
@Service
public class InventoryCheckCheckModelServiceImpl implements InventoryCheckModelService {

  @Autowired
  private InventoryCheckRepository inventoryCheckRepository;

  @Autowired
  private InventoryCheckDetailRepository inventoryCheckDetailRepository;

  @Autowired
  private NebulaToolkitService nebulaToolkitService;

  @Override
  public InventoryCheckModel findByParentCodeAndDynamicKey(String parentCode, String dynamicKey) {
    if (StringUtils.isAnyEmpty(parentCode, dynamicKey)) {
      return null;
    }
    InventoryCheckEntity inventoryCheckEntity = this.inventoryCheckRepository.findByParentCodeAndDynamicKey(parentCode, dynamicKey);
    if (ObjectUtils.isEmpty(inventoryCheckEntity)) {
      return null;
    }
    inventoryCheckEntity.setDetails(this.inventoryCheckDetailRepository.findByCheckId(inventoryCheckEntity.getId()));
    return this.nebulaToolkitService.copyObjectByWhiteList(inventoryCheckEntity, InventoryCheckModel.class, HashSet.class, ArrayList.class, "details");
  }
}
