package com.biz.crm.sfa.business.inventory.check.local.strategy;

import com.biz.crm.common.form.sdk.model.DynamicFormOperationStrategy;
import com.biz.crm.sfa.business.inventory.check.local.entity.InventoryCheckEntity;
import com.biz.crm.sfa.business.inventory.check.local.model.InventoryCheckModel;
import com.biz.crm.sfa.business.inventory.check.local.service.InventoryCheckModelService;
import com.biz.crm.sfa.business.inventory.check.local.service.InventoryCheckService;
import com.biz.crm.sfa.business.step.sdk.register.StepFormModuleRegister;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.HashSet;

@Component
public class DynamicFormOperationStrategyForInventoryCheck implements DynamicFormOperationStrategy<InventoryCheckModel> {

  @Autowired
  private StepFormModuleRegister stepFormModuleRegister;

  @Autowired
  private InventoryCheckService inventoryCheckService;

  @Autowired
  private NebulaToolkitService nebulaToolkitService;

  @Autowired
  private InventoryCheckModelService inventoryCheckModelService;

  @Override
  public void onDynamicFormCreate(InventoryCheckModel dynamicForm, String dynamicKey, String parentCode, Object parent) {
    dynamicForm.setParentCode(parentCode);
    dynamicForm.setDynamicKey(dynamicKey);
    InventoryCheckEntity inventoryCheckEntity = this.nebulaToolkitService.copyObjectByWhiteList(dynamicForm, InventoryCheckEntity.class, HashSet.class, ArrayList.class, "details");
    this.inventoryCheckService.create(inventoryCheckEntity);
  }

  @Override
  public void onDynamicFormModify(InventoryCheckModel dynamicForm, String dynamicKey, String parentCode, Object parent) {
    dynamicForm.setParentCode(parentCode);
    dynamicForm.setDynamicKey(dynamicKey);
    InventoryCheckEntity inventoryCheckEntity = this.nebulaToolkitService.copyObjectByWhiteList(dynamicForm, InventoryCheckEntity.class, HashSet.class, ArrayList.class, "details");
    this.inventoryCheckService.update(inventoryCheckEntity);
  }

  @Override
  public InventoryCheckModel findByParentCode(String dynamicKey, String parentCode) {
    if (StringUtils.isAnyBlank(dynamicKey, parentCode)) {
      return null;
    }
    return this.inventoryCheckModelService.findByParentCodeAndDynamicKey(parentCode, dynamicKey);
  }

  @Override
  public String dynamicFormCode() {
    return StringUtils.uncapitalize(this.getClass().getSimpleName());
  }

  @Override
  public String dynamicFormName() {
    return "库存盘点";
  }

  @Override
  public Class<InventoryCheckModel> dynamicFormClass() {
    return InventoryCheckModel.class;
  }

  @Override
  public String moduleCode() {
    return this.stepFormModuleRegister.moduleCode();
  }

  @Override
  public void onDynamicFormsDelete(String parentCode, String dynamicKey) {

  }

  @Override
  public int getOrder() {
    return 10;
  }
}
