package com.biz.crm.sfa.business.inventory.check.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.sfa.business.inventory.check.local.entity.InventoryCheckEntity;
import com.biz.crm.sfa.business.inventory.check.local.service.InventoryCheckService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Slf4j
@Api(tags = "库存盘点：inventoryCheck:库存盘点")
@RequestMapping("/v1/inventoryCheck/inventoryCheck")
public class InventoryCheckController {

  @Autowired
  private InventoryCheckService inventoryCheckService;

  /**
   * 创建工库存盘点
   *
   * @param entity 库存盘点
   * @return 创建结果
   */
  @ApiOperation("创建库存盘点")
  @PostMapping("")
  public Result<InventoryCheckEntity> create(@RequestBody InventoryCheckEntity entity) {
    return Result.ok(this.inventoryCheckService.create(entity));
  }

  /**
   * 更新工库存盘点
   *
   * @param entity 库存盘点
   * @return 更新结果
   */
  @ApiOperation("更新库存盘点")
  @PatchMapping("")
  public Result<InventoryCheckEntity> update(@RequestBody InventoryCheckEntity entity) {
    return Result.ok(this.inventoryCheckService.update(entity));
  }

  /**
   * 分页查询库存盘点列表
   *
   * @param pageable             分页信息
   * @param inventoryCheckEntity 查询参数
   * @return 库存盘点列表
   */
  @ApiModelProperty("分页查询库存盘点列表")
  @GetMapping("findByConditions")
  public Result<Page<InventoryCheckEntity>> findByConditions(@PageableDefault(50) Pageable pageable,
                                                             @ApiParam(name = "sfaLeaveListDto", value = "分页Dto") InventoryCheckEntity inventoryCheckEntity) {
    return Result.ok(this.inventoryCheckService.findByConditions(pageable, inventoryCheckEntity));
  }

  /**
   * 根据id查询库存盘点详情
   *
   * @param id id
   * @return 库存盘点详情
   */
  @ApiModelProperty("查询库存盘点详情")
  @GetMapping("findDetailById")
  public Result<InventoryCheckEntity> findDetailById(@RequestParam("id") String id) {
    return Result.ok(this.inventoryCheckService.findDetailById(id));
  }

  /**
   * 根据客户查看库存盘点最后一条记录
   *
   * @param clientCode 客户编码
   * @param clientType 客户类型
   * @return 库存盘点列表
   */
  @ApiModelProperty("根据客户查看库存盘点最后一条记录")
  @GetMapping("findLatestByClientTypeAndClientCode")
  public Result<InventoryCheckEntity> findLatestByClientTypeAndClientCode(@ApiParam(name = "clientCode", value = "客户编码") @RequestParam("clientCode") String clientCode,
                                                                          @ApiParam(name = "clientType", value = "客户类型") @RequestParam("clientType") String clientType) {
    try {
      return Result.ok(this.inventoryCheckService.findLatestByClientTypeAndClientCode(clientType, clientCode));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
