package com.biz.crm.sfa.business.inventory.check.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

/**
 * 库存盘点实体类
 *
 * @author jerry7
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "InventoryCheckDetailEntity", description = "库存盘点详情实体类")
@Entity
@TableName("sfa_inventory_check_detail")
@Table(name = "sfa_inventory_check_detail")
@org.hibernate.annotations.Table(appliesTo = "sfa_inventory_check_detail", comment = "库存盘点详情表")
public class InventoryCheckDetailEntity extends UuidEntity {

  /**
   * 库存盘点编码
   */
  @Column(name = "check_id", length = 64, columnDefinition = "VARCHAR(64) NOT NULL COMMENT '库存盘点编码'")
  @ApiModelProperty("库存盘点编码")
  private String checkId;

  /**
   * 产品层级编码
   */
  @Column(name = "product_level_code", length = 64, columnDefinition = "VARCHAR(64) NOT NULL COMMENT '产品层级编码'")
  @ApiModelProperty("产品层级编码")
  private String productLevelCode;

  /**
   * 产品层级名称
   */
  @Column(name = "product_level_name", length = 64, columnDefinition = "VARCHAR(64) NOT NULL COMMENT '产品层级名称'")
  @ApiModelProperty("产品层级名称")
  private String productLevelName;

  /**
   * 产品编码
   */
  @Column(name = "product_code", length = 64, columnDefinition = "VARCHAR(64) NOT NULL COMMENT '产品编码'")
  @ApiModelProperty("产品编码")
  private String productCode;

  /**
   * 产品名称
   */
  @Column(name = "product_name", length = 64, columnDefinition = "VARCHAR(64) NOT NULL COMMENT '产品名称'")
  @ApiModelProperty("产品名称")
  private String productName;

  /**
   * 数量
   */
  @Column(name = "quantify", length = 9, columnDefinition = "int(9) NOT NULL COMMENT '数量'")
  @ApiModelProperty("数量")
  private String quantify;

  /**
   * 产品单位编码
   */
  @Column(name = "product_unit", length = 64, columnDefinition = "VARCHAR(64) NOT NULL COMMENT '产品单位编码'")
  @ApiModelProperty("产品单位编码")
  private String productUnit;

  /**
   * 产品单位名称
   */
  @Column(name = "product_unit_name", length = 64, columnDefinition = "VARCHAR(64) NOT NULL COMMENT '产品单位名称'")
  @ApiModelProperty("产品单位名称")
  private String productUnitName;

  /**
   * 产品图片地址
   */
  @Column(name = "product_img_url", length = 128, columnDefinition = "VARCHAR(128) COMMENT '产品图片地址'")
  @ApiModelProperty("产品图片地址")
  private String productImgUrl;




}
