package com.biz.crm.sfa.business.inventory.check.local.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.common.form.sdk.field.annotation.DynamicField;
import com.biz.crm.common.form.sdk.field.annotation.Validate;
import com.biz.crm.common.form.sdk.field.validate.NotBlankValidateStrategy;
import com.biz.crm.common.form.sdk.widget.SimpleInputWidget;
import com.biz.crm.sfa.business.template.sdk.widget.SimpleNotShowWidget;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

/**
 * 库存盘点实体类
 *
 * @author jerry7
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "InventoryCheckDetailModel", description = "库存盘点详情Model")
public class InventoryCheckDetailModel extends UuidEntity {

  /**
   * 库存盘点编码
   */
  @ApiModelProperty("库存盘点编码")
  @DynamicField(fieldName = "库存盘点编码", validates = {@Validate(value = NotBlankValidateStrategy.class)}, controllKey = SimpleNotShowWidget.class)
  private String checkId;

  /**
   * 产品层级编码
   */
  @ApiModelProperty("产品层级编码")
  @DynamicField(fieldName = "产品层级编码", validates = {@Validate(value = NotBlankValidateStrategy.class)}, controllKey = SimpleNotShowWidget.class)
  private String productLevelCode;

  /**
   * 产品层级名称
   */
  @ApiModelProperty("产品层级名称")
  @DynamicField(fieldName = "产品层级名称", validates = {@Validate(value = NotBlankValidateStrategy.class)}, controllKey = SimpleInputWidget.class)
  private String productLevelName;

  /**
   * 产品编码
   */
  @ApiModelProperty("产品编码")
  @DynamicField(fieldName = "产品编码", validates = {@Validate(value = NotBlankValidateStrategy.class)}, controllKey = SimpleNotShowWidget.class)
  private String productCode;

  /**
   * 产品名称
   */
  @ApiModelProperty("产品名称")
  @DynamicField(fieldName = "产品名称", validates = {@Validate(value = NotBlankValidateStrategy.class)}, controllKey = SimpleInputWidget.class)
  private String productName;

  /**
   * 数量
   */
  @ApiModelProperty("数量")
  @DynamicField(fieldName = "数量", validates = {@Validate(value = NotBlankValidateStrategy.class)}, controllKey = SimpleInputWidget.class)
  private String quantify;

  /**
   * 产品单位编码
   */
  @ApiModelProperty("产品单位编码")
  @DynamicField(fieldName = "产品单位编码", validates = {@Validate(value = NotBlankValidateStrategy.class)}, controllKey = SimpleNotShowWidget.class)
  private String productUnit;

  /**
   * 产品单位名称
   */
  @ApiModelProperty("产品名称")
  @DynamicField(fieldName = "产品名称", validates = {@Validate(value = NotBlankValidateStrategy.class)}, controllKey = SimpleNotShowWidget.class)
  private String productUnitName;

  /**
   * 产品图片地址
   */
  @ApiModelProperty("产品图片地址")
  @DynamicField(fieldName = "产品图片地址", validates = {@Validate(value = NotBlankValidateStrategy.class)}, controllKey = SimpleInputWidget.class)
  private String productImgUrl;
}
