package com.biz.crm.sfa.business.inventory.check.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.sfa.business.inventory.check.local.entity.InventoryCheckDetailEntity;
import com.biz.crm.sfa.business.inventory.check.local.mapper.InventoryCheckDetailMapper;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 库存盘点详情数据操作repository
 *
 * @author jerry7
 */
@Component
public class InventoryCheckDetailRepository extends ServiceImpl<InventoryCheckDetailMapper, InventoryCheckDetailEntity> {

  /**
   * 根据库存盘点id删除库存盘点详情
   *
   * @param checkId 库存盘点id
   */
  public void deleteByCheckId(String checkId) {
    this.lambdaUpdate().eq(InventoryCheckDetailEntity::getCheckId, checkId).remove();
  }

  /**
   * 根据库存盘点id查询库存盘点详情列表
   * @param checkId 库存盘点id
   * @return 库存详情列表
   */
  public List<InventoryCheckDetailEntity> findByCheckId(String checkId) {
    return this.lambdaQuery().eq(InventoryCheckDetailEntity::getCheckId, checkId)
            .list();
  }
}
