package com.biz.crm.sfa.business.inventory.check.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.sfa.business.inventory.check.local.entity.InventoryCheckEntity;
import com.biz.crm.sfa.business.inventory.check.local.mapper.InventoryCheckMapper;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 库存盘点数据操作repository
 *
 * @author jerry7
 */
@Component
public class InventoryCheckRepository extends ServiceImpl<InventoryCheckMapper, InventoryCheckEntity> {


  /**
   * 根据上级id和表单key查询库存盘点实体
   *
   * @param parentCode 上级id
   * @param dynamicKey 表单key
   * @return 库存盘点实体
   */
  public InventoryCheckEntity findByParentCodeAndDynamicKey(String parentCode, String dynamicKey) {
    return this.lambdaQuery().eq(InventoryCheckEntity::getParentCode, parentCode)
        .eq(InventoryCheckEntity::getDynamicKey, dynamicKey)
        .one();
  }

  /**
   * 分页查询库存盘点列表
   *
   * @param pageable             分页信息
   * @param inventoryCheckEntity 查询参数
   * @return 库存盘点列表
   */
  public Page<InventoryCheckEntity> findByConditions(Pageable pageable, InventoryCheckEntity inventoryCheckEntity) {
    Page<InventoryCheckEntity> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    return this.baseMapper.findByConditions(page, inventoryCheckEntity);
  }

  /**
   * 根据客户查看库存盘点
   *
   * @param clientCode 客户编码
   * @param clientType 客户类型
   * @return 库存盘点列表
   */
  public List<InventoryCheckEntity> findLatestByClientTypeAndClientCode(String clientType, String clientCode) {
    return this.lambdaQuery().eq(InventoryCheckEntity::getClientCode, clientCode)
        .eq(InventoryCheckEntity::getClientType, clientType)
        .orderByDesc(InventoryCheckEntity::getCreateTime)
        .list();
  }
}
