package com.biz.crm.sfa.business.inventory.check.local.strategy;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.sfa.business.inventory.check.local.model.InventoryCheckModel;
import com.biz.crm.sfa.business.template.sdk.abstracts.AbstractDynamicTemplateModel;
import com.biz.crm.sfa.business.template.sdk.strategy.DynamicTemplateOperationStrategy;
import com.bizunited.nebula.common.util.JsonUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 库存盘点表单模板操作策略实现类
 *
 * @author jerry7
 */
@Component
public class DynamicTemplateOperationStrategyForInventoryCheckModel implements DynamicTemplateOperationStrategy {

  @Autowired
  private DynamicFormOperationStrategyForInventoryCheck dynamicFormOperationStrategyForInventoryCheck;

  @Override
  public String dynamicFormCode() {
    return this.dynamicFormOperationStrategyForInventoryCheck.dynamicFormCode();
  }

  @Override
  public void onDynamicTemplateCreate(JSONObject jsonObject, String dynamicKey, String parentCode) {
    InventoryCheckModel goodsCollectModel = JsonUtils.json2Obj(jsonObject.toJSONString(), InventoryCheckModel.class);
    this.dynamicFormOperationStrategyForInventoryCheck.onDynamicFormCreate(goodsCollectModel, dynamicKey, parentCode, null);
  }

  @Override
  public void onDynamicTemplateModify(JSONObject jsonObject, String dynamicKey, String parentCode) {
    InventoryCheckModel goodsCollectModel = JsonUtils.json2Obj(jsonObject.toJSONString(), InventoryCheckModel.class);
    this.dynamicFormOperationStrategyForInventoryCheck.onDynamicFormModify(goodsCollectModel, dynamicKey, parentCode, null);
  }

  @Override
  public AbstractDynamicTemplateModel findByParentCode(String dynamicKey, String parentCode) {
    return this.dynamicFormOperationStrategyForInventoryCheck.findByParentCode(dynamicKey, parentCode);
  }
}
