package com.biz.crm.sfa.business.inventory.check.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * 库存盘点DTO
 * @author jerry7
 */
@Data
@ApiModel("库存盘点Dto")
public class InventoryCheckVo extends TenantFlagOpVo {

  /**
   * 站点编码
   */
  @ApiModelProperty("站点编码")
  private String clientCode;

  /**
   * 站点名称
   */
  @ApiModelProperty("站点名称")
  private String clientName;

  /**
   * 站点类别
   */
  @ApiModelProperty("站点类别(经销商/终端)")
  private String clientType;

  /**
   * 位置信息：经度
   */
  @ApiModelProperty("位置信息:经度")
  private String longitude;

  /**
   * 位置信息：纬度
   */
  @ApiModelProperty("位置信息:纬度")
  private String latitude;

  /**
   * 位置信息
   */
  @ApiModelProperty("位置信息")
  private String checkAddress;

  /**
   * 产品层级数量
   */
  @ApiModelProperty("产品层级数量")
  private String productLevelQuantify;

  /**
   * 商品种类数量
   */
  @ApiModelProperty("商品种类数量")
  private String productTypeQuantify;

  /**
   * 商品数量
   */
  @ApiModelProperty("商品数量")
  private String productQuantify;

  /**
   * 盘库详情
   */
  @ApiModelProperty("盘库详情")
  private List<InventoryCheckDetailVo> detailVoList;
}
