package com.biz.crm.sfa.business.inventory.check.sdk;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import com.biz.crm.business.common.sdk.dto.UuidDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;

/**
 * 库存盘点详情DTO
 * @author jerry7
 */
@Data
@ApiModel("库存盘点详情Dto")
public class InventoryCheckDetailDto extends UuidDto {
  /**
   * 库存盘点编码
   */
  @ApiModelProperty("库存盘点编码")
  private String checkId;

  /**
   * 产品层级编码
   */
  @ApiModelProperty("产品层级编码")
  private String productLevelCode;

  /**
   * 产品层级名称
   */
  @ApiModelProperty("产品层级名称")
  private String productLevelName;

  /**
   * 产品编码
   */
  @ApiModelProperty("产品编码")
  private String productCode;

  /**
   * 产品名称
   */
  @ApiModelProperty("产品名称")
  private String productName;

  /**
   * 数量
   */
  @ApiModelProperty("数量")
  private String quantify;

  /**
   * 产品单位编码
   */
  @ApiModelProperty("产品单位编码")
  private String productUnit;

  /**
   * 产品单位名称
   */
  @ApiModelProperty("产品名称")
  private String productUnitName;

  /**
   * 产品图片地址
   */
  @ApiModelProperty("产品图片地址")
  private String productImgUrl;

}
