/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sfa.business.template.local.service.internal;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.utils.DistanceUtil;
import com.biz.crm.common.form.sdk.model.DynamicForm;
import com.biz.crm.common.form.sdk.model.OperationStrategy;
import com.biz.crm.common.form.sdk.module.ModuleRegister;
import com.biz.crm.sfa.business.client.sdk.strategy.ClientRouteStrategy;
import com.biz.crm.sfa.business.client.sdk.vo.ClientRouteInfoVo;
import com.biz.crm.sfa.business.step.sdk.enums.VisitTypeEnum;
import com.biz.crm.sfa.business.step.sdk.listerner.StepFormIntegralListener;
import com.biz.crm.sfa.business.step.sdk.register.NecessaryFormRegister;
import com.biz.crm.sfa.business.step.sdk.service.StepFormVoService;
import com.biz.crm.sfa.business.step.sdk.strategy.ExecutePlanCallBackStrategy;
import com.biz.crm.sfa.business.step.sdk.vo.StepFormVo;
import com.biz.crm.sfa.business.template.sdk.abstracts.AbstractDynamicTemplateModel;
import com.biz.crm.sfa.business.template.sdk.dto.DynamicTemplateDto;
import com.biz.crm.sfa.business.template.sdk.dto.DynamicTemplateModelDto;
import com.biz.crm.sfa.business.template.sdk.service.DynamicTemplateService;
import com.biz.crm.sfa.business.template.sdk.strategy.DynamicTemplateOperationStrategy;
import com.biz.crm.sfa.business.template.sdk.vo.DynamicTemplateVo;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class DynamicTemplateServiceImpl
implements DynamicTemplateService {
    @Order
    @Autowired(required=false)
    private List<ModuleRegister> moduleRegisters;
    @Order
    @Autowired(required=false)
    private List<OperationStrategy<? extends DynamicForm>> operationStrategies;
    @Autowired(required=false)
    private List<DynamicTemplateOperationStrategy> dynamicTemplateOperationStrategies;
    @Autowired
    private List<ExecutePlanCallBackStrategy> completeStatusCallBackStrategies;
    @Autowired(required=false)
    private List<NecessaryFormRegister> necessaryFormRegisters;
    @Autowired(required=false)
    private List<StepFormIntegralListener> stepFormIntegralListeners;
    @Autowired(required=false)
    private StepFormVoService stepFormVoService;
    @Autowired(required=false)
    private List<ClientRouteStrategy> clientRouteStrategies;

    public Page<DynamicTemplateVo> findByConditions(Pageable pageable, DynamicTemplateDto dto) {
        if (CollectionUtils.isEmpty(this.moduleRegisters) || CollectionUtils.isEmpty(this.operationStrategies)) {
            return new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        }
        if (pageable == null) {
            pageable = PageRequest.of((int)0, (int)50);
        }
        if (dto == null) {
            dto = new DynamicTemplateDto();
        }
        List<Object> templates = Lists.newArrayList();
        for (ModuleRegister moduleRegister : this.moduleRegisters) {
            String moduleCode = moduleRegister.moduleCode();
            String moduleName = moduleRegister.moduleName();
            for (OperationStrategy<? extends DynamicForm> operationStrategy : this.operationStrategies) {
                String moduleCodeItem = operationStrategy.moduleCode();
                if (!StringUtils.equals((CharSequence)moduleCode, (CharSequence)moduleCodeItem)) continue;
                String dynamicFormCode = operationStrategy.dynamicFormCode();
                String dynamicFormName = operationStrategy.dynamicFormName();
                Class dynamicClass = operationStrategy.dynamicFormClass();
                DynamicTemplateVo template = new DynamicTemplateVo();
                template.setModuleCode(moduleCode);
                template.setModuleName(moduleName);
                template.setDynamicFormCode(dynamicFormCode);
                template.setDynamicFormName(dynamicFormName);
                template.setDynamicFormSimpleClass(dynamicClass.getSimpleName());
                templates.add(template);
            }
        }
        if (CollectionUtils.isEmpty((Collection)templates)) {
            return new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getModuleCode())) {
            String moduleCode = dto.getModuleCode();
            templates = templates.stream().filter(e -> StringUtils.equals((CharSequence)moduleCode, (CharSequence)e.getModuleCode())).collect(Collectors.toList());
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getModuleName())) {
            String moduleName = dto.getModuleName();
            templates = templates.stream().filter(e -> StringUtils.indexOf((CharSequence)e.getModuleName(), (CharSequence)moduleName) >= 0).collect(Collectors.toList());
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getDynamicFormCode())) {
            String dynamicFormCode = dto.getDynamicFormCode();
            templates = templates.stream().filter(e -> StringUtils.equals((CharSequence)dynamicFormCode, (CharSequence)e.getDynamicFormCode())).collect(Collectors.toList());
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getDynamicFormName())) {
            String dynamicFormName = dto.getDynamicFormName();
            templates = templates.stream().filter(e -> StringUtils.indexOf((CharSequence)e.getDynamicFormName(), (CharSequence)dynamicFormName) >= 0).collect(Collectors.toList());
        }
        long totalSize = templates.size();
        templates = templates.stream().skip(pageable.getPageSize() * pageable.getPageNumber() > 0 ? (long)(pageable.getPageNumber() - 1) : 0L).limit(pageable.getPageSize()).collect(Collectors.toList());
        Page result = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        result.setRecords((List)templates);
        result.setTotal(totalSize);
        return result;
    }

    @Transactional
    public void handleCreateForm(JSONObject jsonObject) {
        Validate.notNull((Object)jsonObject, (String)"\u521b\u5efa\u8868\u5355\u4fe1\u606f\u65f6\uff0c\u5165\u53c2json\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        String dynamicFormCode = jsonObject.getString("dynamicFormCode");
        Validate.notBlank((CharSequence)dynamicFormCode, (String)"\u521b\u5efa\u8868\u5355\u4fe1\u606f\u65f6\uff0c\u8868\u5355\u7f16\u7801\uff08\u8868\u5355\u7f16\u7801\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Boolean stepFormOrNot = jsonObject.getBoolean("stepFormOrNot");
        Validate.notNull((Object)stepFormOrNot, (String)"\u521b\u5efa\u8868\u5355\u4fe1\u606f\u65f6\uff0c\u662f\u5426\u4e3a\u6b65\u9aa4\u8868\u5355\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        String parentCode = jsonObject.getString("parentCode");
        String dynamicKey = jsonObject.getString("dynamicKey");
        if (stepFormOrNot.booleanValue()) {
            Validate.notBlank((CharSequence)parentCode, (String)"\u521b\u5efa\u8868\u5355\u4fe1\u606f\u65f6\uff0c\u8868\u5355\u5173\u8054\u7236\u7ea7\u7f16\u7801\uff08\u660e\u7ec6\u552f\u4e00\u7f16\u7801\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)dynamicKey, (String)"\u521b\u5efa\u8868\u5355\u4fe1\u606f\u65f6\uff0c\u8868\u5355\u5173\u8054\u52a8\u6001key\uff08\u6b65\u9aa4\u7f16\u7801\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            this.validateLongitudeAndLatitude(jsonObject);
        }
        Validate.isTrue((!CollectionUtils.isEmpty(this.dynamicTemplateOperationStrategies) ? 1 : 0) != 0, (String)"\u672a\u67e5\u8be2\u5230\u8868\u5355\u6a21\u578b\u670d\u52a1\u7684\u64cd\u4f5c\u7b56\u7565", (Object[])new Object[0]);
        for (DynamicTemplateOperationStrategy dynamicTemplateOperationStrategy : this.dynamicTemplateOperationStrategies) {
            if (!dynamicTemplateOperationStrategy.dynamicFormCode().equals(dynamicFormCode)) continue;
            dynamicTemplateOperationStrategy.onDynamicTemplateCreate(jsonObject, dynamicKey, parentCode);
            break;
        }
        if (stepFormOrNot.booleanValue()) {
            String visitType = jsonObject.getString("visitType");
            Validate.notBlank((CharSequence)visitType, (String)"\u56de\u8c03\u5b8c\u6210\u72b6\u6001\u65f6\uff0c\u62dc\u8bbf\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notNull((Object)VisitTypeEnum.getByDictCode((String)visitType), (String)"\u56de\u8c03\u66f4\u6539\u5b8c\u6210\u72b6\u6001\u65f6\uff0c\u672a\u5339\u914d\u5230\u5bf9\u5e94\u7684\u62dc\u8bbf\u7c7b\u578b\uff01", (Object[])new Object[0]);
            if (!CollectionUtils.isEmpty(this.completeStatusCallBackStrategies)) {
                for (ExecutePlanCallBackStrategy executePlanCallBackStrategy : this.completeStatusCallBackStrategies) {
                    if (!executePlanCallBackStrategy.visitType().equals(visitType)) continue;
                    executePlanCallBackStrategy.onSave(parentCode, dynamicKey, dynamicFormCode);
                    break;
                }
            }
            if (!CollectionUtils.isEmpty(this.necessaryFormRegisters)) {
                NecessaryFormRegister necessaryFormRegister = (NecessaryFormRegister)this.necessaryFormRegisters.stream().filter(NecessaryFormRegister::first).sorted().collect(Collectors.toList()).get(0);
                NecessaryFormRegister lastNecessaryFormRegister = (NecessaryFormRegister)this.necessaryFormRegisters.stream().filter(NecessaryFormRegister::last).sorted().collect(Collectors.toList()).get(0);
                Validate.notNull((Object)necessaryFormRegister, (String)"\u66f4\u6539\u6267\u884c\u8ba1\u5212\u72b6\u6001\u65f6\uff0c\u672a\u83b7\u53d6\u5230\u7cfb\u7edf\u9884\u8bbe\u7684\u9996\u4f4d\u5fc5\u505a\u6b65\u9aa4\u8868\u5355\uff01", (Object[])new Object[0]);
                Validate.notNull((Object)lastNecessaryFormRegister, (String)"\u66f4\u6539\u6267\u884c\u8ba1\u5212\u72b6\u6001\u65f6\uff0c\u672a\u83b7\u53d6\u5230\u7cfb\u7edf\u9884\u8bbe\u7684\u672b\u4f4d\u5fc5\u505a\u6b65\u9aa4\u8868\u5355\uff01", (Object[])new Object[0]);
                for (ExecutePlanCallBackStrategy executePlanCallBackStrategy : this.completeStatusCallBackStrategies) {
                    if (!executePlanCallBackStrategy.visitType().equals(visitType)) continue;
                    if (necessaryFormRegister.dynamicFormCode().equals(dynamicFormCode)) {
                        executePlanCallBackStrategy.onUpdateExecuteStatus(Boolean.valueOf(false), parentCode);
                    }
                    if (!lastNecessaryFormRegister.dynamicFormCode().equals(dynamicFormCode)) break;
                    executePlanCallBackStrategy.onUpdateExecuteStatus(Boolean.valueOf(true), parentCode);
                    break;
                }
            }
        }
        if (!CollectionUtils.isEmpty(this.stepFormIntegralListeners)) {
            for (StepFormIntegralListener stepFormIntegralListener : this.stepFormIntegralListeners) {
                stepFormIntegralListener.onCreateIntegral(parentCode, dynamicKey, dynamicFormCode);
            }
        }
    }

    @Transactional
    public void handleUpdateForm(JSONObject jsonObject) {
        Validate.notNull((Object)jsonObject, (String)"\u7f16\u8f91\u8868\u5355\u4fe1\u606f\u65f6\uff0c\u5165\u53c2json\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        String dynamicFormCode = jsonObject.getString("dynamicFormCode");
        Validate.notBlank((CharSequence)dynamicFormCode, (String)"\u7f16\u8f91\u8868\u5355\u4fe1\u606f\u65f6\uff0c\u8868\u5355\u7f16\u7801\uff08\u8868\u5355\u7f16\u7801\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Boolean stepFormOrNot = jsonObject.getBoolean("stepFormOrNot");
        Validate.notNull((Object)stepFormOrNot, (String)"\u7f16\u8f91\u8868\u5355\u4fe1\u606f\u65f6\uff0c\u662f\u5426\u4e3a\u6b65\u9aa4\u8868\u5355\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        String parentCode = jsonObject.getString("parentCode");
        String dynamicKey = jsonObject.getString("dynamicKey");
        if (stepFormOrNot.booleanValue()) {
            Validate.notBlank((CharSequence)parentCode, (String)"\u521b\u5efa\u8868\u5355\u4fe1\u606f\u65f6\uff0c\u8868\u5355\u5173\u8054\u7236\u7ea7\u7f16\u7801\uff08\u660e\u7ec6\u552f\u4e00\u7f16\u7801\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)dynamicKey, (String)"\u521b\u5efa\u8868\u5355\u4fe1\u606f\u65f6\uff0c\u8868\u5355\u5173\u8054\u52a8\u6001key\uff08\u6b65\u9aa4\u7f16\u7801\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            this.validateLongitudeAndLatitude(jsonObject);
        }
        Validate.isTrue((!CollectionUtils.isEmpty(this.dynamicTemplateOperationStrategies) ? 1 : 0) != 0, (String)"\u672a\u67e5\u8be2\u5230\u8868\u5355\u6a21\u578b\u670d\u52a1\u7684\u64cd\u4f5c\u7b56\u7565", (Object[])new Object[0]);
        for (DynamicTemplateOperationStrategy dynamicTemplateOperationStrategy : this.dynamicTemplateOperationStrategies) {
            if (!dynamicTemplateOperationStrategy.dynamicFormCode().equals(dynamicFormCode)) continue;
            dynamicTemplateOperationStrategy.onDynamicTemplateModify(jsonObject, dynamicKey, parentCode);
            break;
        }
    }

    public AbstractDynamicTemplateModel findByDynamicTemplateModelDto(DynamicTemplateModelDto model) {
        if (model == null || StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{model.getDynamicFormCode(), model.getDynamicKey(), model.getParentCode()})) {
            return null;
        }
        if (CollectionUtils.isEmpty(this.dynamicTemplateOperationStrategies)) {
            return null;
        }
        for (DynamicTemplateOperationStrategy dynamicTemplateOperationStrategy : this.dynamicTemplateOperationStrategies) {
            if (!dynamicTemplateOperationStrategy.dynamicFormCode().equals(model.getDynamicFormCode())) continue;
            return dynamicTemplateOperationStrategy.findByParentCode(model.getDynamicKey(), model.getParentCode());
        }
        return null;
    }

    private void validateLongitudeAndLatitude(JSONObject jsonObject) {
        String stepCode = jsonObject.getString("dynamicKey");
        List stepCodes = this.stepFormVoService.findByStepCodes((Set)Sets.newHashSet((Object[])new String[]{stepCode}));
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)stepCodes) ? 1 : 0) != 0, (String)"\u672a\u67e5\u8be2\u5230\u53ef\u6267\u884c\u7684\u6b65\u9aa4\uff01", (Object[])new Object[0]);
        StepFormVo stepFormVo = (StepFormVo)stepCodes.get(0);
        if (!stepFormVo.getLocateType().booleanValue()) {
            return;
        }
        BigDecimal longitude = jsonObject.getBigDecimal("longitude");
        BigDecimal latitude = jsonObject.getBigDecimal("latitude");
        String clientCode = jsonObject.getString("clientCode");
        String clientType = jsonObject.getString("clientType");
        String clientRoute = jsonObject.getString("clientRoute");
        Validate.notNull((Object)latitude, (String)"\u9a8c\u8bc1\u662f\u5426\u5b9a\u4f4d\u65f6\uff0c\u7eac\u5ea6\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)longitude, (String)"\u9a8c\u8bc1\u662f\u5426\u5b9a\u4f4d\u65f6\uff0c\u7ecf\u5ea6\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)clientCode, (String)"\u9a8c\u8bc1\u662f\u5426\u5b9a\u4f4d\u65f6\uff0c\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)clientType, (String)"\u9a8c\u8bc1\u662f\u5426\u5b9a\u4f4d\u65f6\uff0c\u5ba2\u6237\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)clientRoute, (String)"\u9a8c\u8bc1\u662f\u5426\u5b9a\u4f4d\u65f6\uff0c\u5ba2\u6237\u7ef4\u5ea6\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((!CollectionUtils.isEmpty(this.clientRouteStrategies) ? 1 : 0) != 0, (String)"\u672a\u67e5\u8be2\u5230\u5ba2\u6237\u7ef4\u5ea6\u6ce8\u518c\u5668\uff01", (Object[])new Object[0]);
        List currentClientRouteStrategies = this.clientRouteStrategies.stream().filter(clientRouteStrategy -> clientRouteStrategy.getKey().equals(clientRoute)).collect(Collectors.toList());
        Validate.isTrue((!CollectionUtils.isEmpty(currentClientRouteStrategies) ? 1 : 0) != 0, (String)"\u65e0\u6cd5\u8bc6\u522b\u5f53\u524d\u5ba2\u6237\u7684\u6765\u6e90\u7ef4\u5ea6\uff01", (Object[])new Object[0]);
        ClientRouteInfoVo clientRouteInfoVo = new ClientRouteInfoVo();
        for (ClientRouteStrategy clientRouteStrategy2 : this.clientRouteStrategies) {
            if (!clientRoute.equals(clientRouteStrategy2.getKey())) continue;
            List clientRouteInfoVos = clientRouteStrategy2.onFindByClientCodesAndType((List)Lists.newArrayList((Object[])new String[]{clientCode}), clientType);
            Validate.notNull((Object)(!CollectionUtils.isEmpty((Collection)clientRouteInfoVos) ? 1 : 0), (String)"\u9a8c\u8bc1\u662f\u5426\u5b9a\u4f4d\u65f6\uff0c\u672a\u67e5\u8be2\u5230\u5ba2\u6237\u4fe1\u606f", (Object[])new Object[0]);
            clientRouteInfoVo = (ClientRouteInfoVo)clientRouteInfoVos.get(0);
            break;
        }
        BigDecimal longitudeParam = clientRouteInfoVo.getLongitude();
        BigDecimal latitudeParam = clientRouteInfoVo.getLatitude();
        Validate.notNull((Object)longitudeParam, (String)"\u5f53\u524d\u7ad9\u70b9\u6ca1\u6709\u914d\u7f6e\u4f4d\u7f6e\uff08\u7ecf\u5ea6\uff09\u4fe1\u606f", (Object[])new Object[0]);
        Validate.notNull((Object)latitudeParam, (String)"\u5f53\u524d\u7ad9\u70b9\u6ca1\u6709\u914d\u7f6e\u4f4d\u7f6e\uff08\u7eac\u5ea6\uff09\u4fe1\u606f", (Object[])new Object[0]);
        double distance = DistanceUtil.calculatePointDistance((double)latitude.doubleValue(), (double)longitude.doubleValue(), (double)latitudeParam.doubleValue(), (double)longitudeParam.doubleValue());
        Validate.isTrue((BigDecimal.valueOf(distance).compareTo(BigDecimal.valueOf(stepFormVo.getDistance().intValue())) <= 0 ? 1 : 0) != 0, (String)"\u9a8c\u8bc1\u662f\u5426\u5b9a\u4f4d\u65f6\uff0c\u8d85\u8fc7\u6b65\u9aa4\u9650\u5236\u8ddd\u79bb\uff1a%s\u7c73", (long)stepFormVo.getDistance().intValue());
    }
}

