package com.biz.crm.sfa.business.template.local.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.sfa.business.template.sdk.abstracts.AbstractDynamicTemplateModel;
import com.biz.crm.sfa.business.template.sdk.dto.DynamicTemplateDto;
import com.biz.crm.sfa.business.template.sdk.dto.DynamicTemplateModelDto;
import com.biz.crm.sfa.business.template.sdk.service.DynamicTemplateService;
import com.biz.crm.sfa.business.template.sdk.strategy.StrangeVisitValidateLocationStrategy;
import com.biz.crm.sfa.business.template.sdk.vo.DynamicTemplateVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 动态模板管理(DynamicTemplateController)表相关的http接口
 *
 * @author hc
 * @since 2022-05-17 12:54:04
 */
@RestController
@RequestMapping("/v1/template/dynamicTemplate")
@Slf4j
@Api(tags = "动态模板管理：DynamicTemplate：动态模板管理")
public class DynamicTemplateController {

  @Autowired
  private DynamicTemplateService dynamicTemplateService;
  @Autowired(required = false)
  private List<StrangeVisitValidateLocationStrategy> strangeVisitValidateLocationStrategies;


  @ApiOperation(value = "分页查询所有数据")
  @GetMapping("findByConditions")
  public Result<Page<DynamicTemplateVo>> findByConditions(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                          @ApiParam(name = "dynamicTemplateDto", value = "动态模型查询参数信息") DynamicTemplateDto dto) {
    try {
      Page<DynamicTemplateVo> page = this.dynamicTemplateService.findByConditions(pageable, dto);
      return Result.ok(page);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }


  /**
   * 新增表单信息
   *
   * @param jsonObject
   * @return
   */
  @ApiOperation(value = "新增表单信息")
  @PostMapping(value = "handleCreateForm")
  public Result<?> handleCreateForm(@RequestBody JSONObject jsonObject) {
    try {
      this.dynamicTemplateService.handleCreateForm(jsonObject);
      return Result.ok();
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 编辑表单信息
   *
   * @param jsonObject
   * @return
   */
  @ApiOperation(value = "编辑表单信息")
  @PostMapping(value = "handleUpdateForm")
  public Result<?> handleUpdateForm(@RequestBody JSONObject jsonObject) {
    try {
      this.dynamicTemplateService.handleUpdateForm(jsonObject);
      return Result.ok();
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 查看表单信息
   *
   * @param model
   * @return
   */
  @ApiOperation(value = "查看表单信息")
  @GetMapping(value = "findByDynamicTemplateModelDto")
  public Result<AbstractDynamicTemplateModel> findByDynamicTemplateModelDto(@ApiParam(name = "model", value = "入参对象") DynamicTemplateModelDto model) {
    try {
      AbstractDynamicTemplateModel abstractDynamicTemplateModel = this.dynamicTemplateService.findByDynamicTemplateModelDto(model);
      return Result.ok(abstractDynamicTemplateModel);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 获取定位地图类型
   *
   * @return
   */
  @ApiOperation(value = "获取定位地图类型")
  @GetMapping(value = "findMapType")
  public Result<Map<String, String>> findMapType() {
    try {
      Map<String, String> map = new HashMap<>();
      if (!CollectionUtils.isEmpty(strangeVisitValidateLocationStrategies)) {
        for (StrangeVisitValidateLocationStrategy strategy : strangeVisitValidateLocationStrategies) {
          map.put(strategy.key(), strategy.name());
        }
      }
      return Result.ok(map);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

}
