package com.biz.crm.sfa.business.template.outstore.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.sfa.business.template.sdk.abstracts.AbstractDynamicTemplateEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @description: 离店打卡
 * @author: rentao
 * @date: 2022/6/16 16:06
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Entity
@TableName("sfa_outstore_clock")
@Table(name = "sfa_outstore_clock")
@ApiModel(value = "OutstoreClock", description = "离店打卡")
@org.hibernate.annotations.Table(appliesTo = "sfa_outstore_clock", comment = "离店打卡")
public class OutstoreClock extends AbstractDynamicTemplateEntity {

  private static final long serialVersionUID = -7266083925810089681L;

  @ApiModelProperty("店铺编码")
  @Column(name = "store_code", length = 32, nullable = false,columnDefinition = "VARCHAR(32) COMMENT '店铺编码'")
  private String storeCode;

  @ApiModelProperty("店铺名称")
  @Column(name = "store_name", length = 32, nullable = false,columnDefinition = "VARCHAR(32) COMMENT '店铺名称'")
  private String storeName;

  @ApiModelProperty("打卡地点")
  @Column(name = "clock_place", length = 500,columnDefinition = "VARCHAR(500) COMMENT '打卡地点'")
  private String clockPlace;

  @ApiModelProperty("打卡地点经度")
  @Column(name = "clock_longitude", columnDefinition = "decimal(12,8) COMMENT '打卡地点经度'")
  private BigDecimal clockLongitude;

  @ApiModelProperty("打卡地点地点纬度")
  @Column(name = "clock_latitude", columnDefinition = "decimal(12,8) COMMENT '打卡地点地点纬度'")
  private BigDecimal clockLatitude;

  @ApiModelProperty("创建人岗位名称")
  @Column(name = "create_pos_name", length = 200, columnDefinition = "varchar(200) COMMENT '创建人岗位名称'")
  private String createPosName;

  @ApiModelProperty("创建人岗位")
  @Column(name = "create_pos_code", length = 200, columnDefinition = "varchar(200) COMMENT '创建人岗位'")
  private String createPosCode;

  @ApiModelProperty("创建人组织")
  @Column(name = "create_org_code", length = 200, columnDefinition = "varchar(200) COMMENT '创建人组织'")
  private String createOrgCode;

  @ApiModelProperty("创建人组织名称")
  @Column(name = "create_org_name", length = 200, columnDefinition = "varchar(200) COMMENT '创建人组织名称'")
  private String createOrgName;

  @ApiModelProperty(value = "访问路径")
  @Column(name = "picture_url", columnDefinition = "VARCHAR(255) COMMENT '访问路径'")
  private String pictureUrl;

}