package com.biz.crm.sfa.business.template.outstore.local.service;

import com.biz.crm.sfa.business.template.outstore.local.entity.OutstoreClock;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.data.domain.Pageable;
import java.util.List;

/**
 * 离店打卡(OutstoreClock)service
 *
 * @author rentao
 * @since 2022-06-16 16:21:37
 */
public interface OutstoreClockService {

  /**
   * 分页查询
   *
   * @param pageable 分页参数
   * @param outstoreClock 分页条件
   * @return
   */
  Page<OutstoreClock> findByConditions(Pageable pageable, OutstoreClock outstoreClock);

  /**
   * ͨid查询详情
   *
   * @param id id主键
   *
   */
  OutstoreClock findById(String id);

  /**
   * 新增
   *
   * @param outstoreClock 新增参数
   * @return
   */
  OutstoreClock create(OutstoreClock outstoreClock);

  /**
   * 编辑
   *
   * @param outstoreClock 编辑参数
   * @return
   */
  OutstoreClock update(OutstoreClock outstoreClock);

  /**
   * 批量删除
   *
   * @param idList id集合
   * @return
   */
  void delete(List<String> idList);

  /**
   * 删除
   *
   * @param parentCode
   * @param dynamicKey
   * @return
   */
  void deleteByParentCodeAndDynamicKey(String parentCode,String dynamicKey);

  /**
   * 离店打卡单个查询
   *
   * @param parentCode
   * @param dynamicKey
   * @return
   */
  OutstoreClock findByParentCodeAndDynamicKey(String parentCode,String dynamicKey);

}
