package com.biz.crm.sfa.business.template.outstore.local.service.internal;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.model.LoginUserDetails;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.sfa.business.template.outstore.local.models.LocInfoModel;
import com.biz.crm.sfa.business.template.outstore.local.models.OutstoreClockModel;
import com.biz.crm.sfa.business.template.outstore.local.models.PictureModel;
import com.biz.crm.sfa.business.template.outstore.local.models.StoreInfoModel;
import com.biz.crm.sfa.business.template.outstore.local.repository.OutstoreClockRepository;
import com.biz.crm.sfa.business.template.outstore.local.entity.OutstoreClock;
import com.biz.crm.sfa.business.template.outstore.local.service.OutstoreClockService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.springframework.stereotype.Service;
import org.springframework.beans.factory.annotation.Autowired;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.data.domain.Pageable;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;

import java.util.List;
import java.util.Objects;

/**
 * 离店打卡(OutstoreClock)serviceImpl
 *
 * @author rentao
 * @since 2022-06-16 16:21:37
 */
@Service("outstoreClockService")
public class OutstoreClockServiceImpl implements OutstoreClockService {

  @Autowired private OutstoreClockRepository outstoreClockRepository;
  @Autowired private LoginUserService loginUserService;


  /**
   * 分页查询
   *
   * @param pageable 分页参数
   * @param outstoreClock 分页条件
   * @return
   */
  @Override
  public Page<OutstoreClock> findByConditions(Pageable pageable, OutstoreClock outstoreClock) {
    ObjectUtils.defaultIfNull(pageable, PageRequest.of(0, 50));
    if (Objects.isNull(outstoreClock)) {
      outstoreClock = new OutstoreClock();
    }
    return this.outstoreClockRepository.findByConditions(pageable, outstoreClock);
  }

  /**
   * ͨid查询详情
   *
   * @param id id主键
   */
  @Override
  public OutstoreClock findById(String id) {
    if (StringUtils.isBlank(id)) {
      return null;
    }
    return this.outstoreClockRepository.getById(id);
  }

  /**
   * 新增
   *
   * @param outstoreClock 新增参数
   * @return
   */
  @Transactional
  @Override
  public OutstoreClock create(OutstoreClock outstoreClock) {
    this.createValidate(outstoreClock);
    this.outstoreClockRepository.saveOrUpdate(outstoreClock);
    return outstoreClock;
  }

  /**
   * 编辑
   *
   * @param outstoreClock 编辑参数
   * @return
   */
  @Transactional
  @Override
  public OutstoreClock update(OutstoreClock outstoreClock) {
    this.updateValidate(outstoreClock);
    this.outstoreClockRepository.saveOrUpdate(outstoreClock);
    return outstoreClock;
  }

  /**
   * 批量删除
   *
   * @param idList id集合
   * @return
   */
  @Transactional
  @Override
  public void delete(List<String> idList) {
    Validate.isTrue(!CollectionUtils.isEmpty(idList), "删除数据时，主键集合不能为空！");
    this.outstoreClockRepository.removeByIds(idList);
  }

  /**
   * 条件删除
   *
   * @param parentCode
   * @param dynamicKey
   * @return
   */
  @Override
  @Transactional
  public void deleteByParentCodeAndDynamicKey(String parentCode, String dynamicKey) {
    this.outstoreClockRepository.deleteByParentCodeAndDynamicKey(parentCode,dynamicKey);
  }

  /**
   * 离店打卡单个查询
   *
   * @param parentCode
   * @param dynamicKey
   * @return
   */
  @Override
  public OutstoreClock findByParentCodeAndDynamicKey(String parentCode, String dynamicKey) {
    return this.outstoreClockRepository.findByParentCodeAndDynamicKey(parentCode,dynamicKey);
  }

  /**
   * 新增验证
   *
   * @param outstoreClock
   */
  private void createValidate(OutstoreClock outstoreClock) {
    Validate.notNull(outstoreClock, "新增信息时，传入参数不能为空");
    outstoreClock.setId(null);
    Validate.notBlank(outstoreClock.getStoreCode(), "新增信息时，店铺编码不能为空");
    Validate.notBlank(outstoreClock.getStoreName(), "新增信息时，店铺名称不能为空");
    outstoreClock.setTenantCode(TenantUtils.getTenantCode());
    LoginUserDetails loginDetails = this.loginUserService.getLoginDetails(LoginUserDetails.class);
    outstoreClock.setCreatePosCode(loginDetails.getPostCode());
    outstoreClock.setCreatePosName(loginDetails.getPostName());
    outstoreClock.setCreateOrgCode(loginDetails.getOrgCode());
    outstoreClock.setCreateOrgName(loginDetails.getOrgName());
  }

  /**
   * 编辑验证
   *
   * @param outstoreClock
   */
  private void updateValidate(OutstoreClock outstoreClock) {
    Validate.notNull(outstoreClock, "修改信息时，传入参数不能为空");
    Validate.notBlank(outstoreClock.getId(), "修改信息时，主键不能为空");
    Validate.notBlank(outstoreClock.getClockPlace(), "修改信息时，打卡地点不能为空");
    Validate.notBlank(outstoreClock.getStoreCode(), "修改信息时，店铺编码不能为空");
    Validate.notBlank(outstoreClock.getStoreName(), "修改信息时，店铺名称不能为空");
    outstoreClock.setTenantCode(TenantUtils.getTenantCode());
  }


  public static void main(String[] args) {
    System.out.println(JSON.toJSONString(new StoreInfoModel(),
        SerializerFeature.WriteMapNullValue));
  }
}
