package com.biz.crm.sfa.business.template.outstore.local.strategy;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.sfa.business.template.outstore.local.models.OutstoreClockModel;
import com.biz.crm.sfa.business.template.sdk.abstracts.AbstractDynamicTemplateModel;
import com.biz.crm.sfa.business.template.sdk.strategy.DynamicTemplateOperationStrategy;
import com.bizunited.nebula.common.util.JsonUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

/**
 * @description: 离店打卡动态表单
 * @author: rentao
 * @date: 2022/6/23 10:34
 */
@Component
@Slf4j
public class DynamicTemplateOperationStrategyOutstoreClockModule implements
    DynamicTemplateOperationStrategy {


  @Autowired
  private DynamicFormOperationStrategyOutstoreClockModule dynamicFormOperationStrategyOutstoreClockModule;

  @Override
  public String dynamicFormCode() {
    return this.dynamicFormOperationStrategyOutstoreClockModule.dynamicFormCode();
  }

  @Override
  @Transactional
  public void onDynamicTemplateCreate(JSONObject jsonObject, String dynamicKey, String parentCode) {
    OutstoreClockModel outstoreClockModel = JsonUtils
        .json2Obj(jsonObject.toJSONString(), OutstoreClockModel.class);
    this.dynamicFormOperationStrategyOutstoreClockModule.onDynamicFormCreate(outstoreClockModel, dynamicKey, parentCode, null);
  }

  @Override
  @Transactional
  public void onDynamicTemplateModify(JSONObject jsonObject, String dynamicKey, String parentCode) {
    OutstoreClockModel outstoreClockModel = JsonUtils.json2Obj(jsonObject.toJSONString(), OutstoreClockModel.class);
    this.dynamicFormOperationStrategyOutstoreClockModule.onDynamicFormModify(outstoreClockModel, dynamicKey, parentCode, null);
  }


  @Override
  public AbstractDynamicTemplateModel findByParentCode(String dynamicKey, String parentCode) {
    return this.dynamicFormOperationStrategyOutstoreClockModule.findByParentCode(dynamicKey, parentCode);
  }

}
