/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sfa.business.template.outstore.local.service.internal;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.LoginUserDetails;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.sfa.business.template.outstore.local.entity.OutstoreClock;
import com.biz.crm.sfa.business.template.outstore.local.models.StoreInfoModel;
import com.biz.crm.sfa.business.template.outstore.local.repository.OutstoreClockRepository;
import com.biz.crm.sfa.business.template.outstore.local.service.OutstoreClockService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="outstoreClockService")
public class OutstoreClockServiceImpl
implements OutstoreClockService {
    @Autowired
    private OutstoreClockRepository outstoreClockRepository;
    @Autowired
    private LoginUserService loginUserService;

    @Override
    public Page<OutstoreClock> findByConditions(Pageable pageable, OutstoreClock outstoreClock) {
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (Objects.isNull((Object)outstoreClock)) {
            outstoreClock = new OutstoreClock();
        }
        return this.outstoreClockRepository.findByConditions(pageable, outstoreClock);
    }

    @Override
    public OutstoreClock findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return (OutstoreClock)((Object)this.outstoreClockRepository.getById((Serializable)((Object)id)));
    }

    @Override
    @Transactional
    public OutstoreClock create(OutstoreClock outstoreClock) {
        this.createValidate(outstoreClock);
        this.outstoreClockRepository.saveOrUpdate((Object)outstoreClock);
        return outstoreClock;
    }

    @Override
    @Transactional
    public OutstoreClock update(OutstoreClock outstoreClock) {
        this.updateValidate(outstoreClock);
        this.outstoreClockRepository.saveOrUpdate((Object)outstoreClock);
        return outstoreClock;
    }

    @Override
    @Transactional
    public void delete(List<String> idList) {
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u5220\u9664\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        this.outstoreClockRepository.removeByIds(idList);
    }

    @Override
    @Transactional
    public void deleteByParentCodeAndDynamicKey(String parentCode, String dynamicKey) {
        this.outstoreClockRepository.deleteByParentCodeAndDynamicKey(parentCode, dynamicKey);
    }

    @Override
    public OutstoreClock findByParentCodeAndDynamicKey(String parentCode, String dynamicKey) {
        return this.outstoreClockRepository.findByParentCodeAndDynamicKey(parentCode, dynamicKey);
    }

    private void createValidate(OutstoreClock outstoreClock) {
        Validate.notNull((Object)((Object)outstoreClock), (String)"\u65b0\u589e\u4fe1\u606f\u65f6\uff0c\u4f20\u5165\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        outstoreClock.setId(null);
        Validate.notBlank((CharSequence)outstoreClock.getStoreCode(), (String)"\u65b0\u589e\u4fe1\u606f\u65f6\uff0c\u5e97\u94fa\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)outstoreClock.getStoreName(), (String)"\u65b0\u589e\u4fe1\u606f\u65f6\uff0c\u5e97\u94fa\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        outstoreClock.setTenantCode(TenantUtils.getTenantCode());
        LoginUserDetails loginDetails = (LoginUserDetails)this.loginUserService.getLoginDetails(LoginUserDetails.class);
        outstoreClock.setCreatePosCode(loginDetails.getPostCode());
        outstoreClock.setCreatePosName(loginDetails.getPostName());
        outstoreClock.setCreateOrgCode(loginDetails.getOrgCode());
        outstoreClock.setCreateOrgName(loginDetails.getOrgName());
    }

    private void updateValidate(OutstoreClock outstoreClock) {
        Validate.notNull((Object)((Object)outstoreClock), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u4f20\u5165\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)outstoreClock.getId(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)outstoreClock.getClockPlace(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u6253\u5361\u5730\u70b9\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)outstoreClock.getStoreCode(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u5e97\u94fa\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)outstoreClock.getStoreName(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u5e97\u94fa\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        outstoreClock.setTenantCode(TenantUtils.getTenantCode());
    }

    public static void main(String[] args) {
        System.out.println(JSON.toJSONString((Object)new StoreInfoModel(), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
    }
}

