package com.biz.crm.sfa.business.template.outstore.local.models;

import com.biz.crm.common.form.sdk.field.annotation.DynamicField;
import com.biz.crm.common.form.sdk.field.annotation.Validate;
import com.biz.crm.common.form.sdk.field.validate.NotBlankValidateStrategy;
import com.biz.crm.common.form.sdk.field.validate.NotNullValidateStrategy;
import com.biz.crm.common.form.sdk.widget.SimpleDecimalInputWidget;
import com.biz.crm.common.form.sdk.widget.SimpleInputWidget;
import io.swagger.annotations.ApiModel;
import java.math.BigDecimal;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

/**
 * @description: 定位业务组件
 * @author: rentao
 * @date: 2022/6/20 14:35
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "LocInfoModel", description = "定位业务组件model")
public class LocInfoModel {

  @DynamicField(fieldName = "打卡地点" , modifiable = false , validates = {@Validate(value = NotBlankValidateStrategy.class)} , controllKey = SimpleInputWidget.class)
  private String clockPlace;

  @DynamicField(fieldName = "打卡地点经度", validates = {@Validate(value = NotNullValidateStrategy.class)} , controllKey = SimpleDecimalInputWidget.class)
  private BigDecimal clockLongitude;

  @DynamicField(fieldName = "打卡地点经度", validates = {@Validate(value = NotNullValidateStrategy.class)} , controllKey = SimpleDecimalInputWidget.class)
  private BigDecimal clockLatitude;
}
