package com.biz.crm.sfa.business.template.outstore.local.models;

import com.biz.crm.common.form.sdk.field.annotation.DynamicField;
import com.biz.crm.common.form.sdk.field.annotation.Validate;
import com.biz.crm.common.form.sdk.field.validate.NotBlankValidateStrategy;
import com.biz.crm.common.form.sdk.widget.SimpleInputWidget;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

/**
 * @description: 离店图片model
 * @author: rentao
 * @date: 2022/6/20 14:46
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "PictureModel", description = "离店图片model")
public class PictureModel {

  private static final long serialVersionUID = -2765289943786899179L;

  /**
   * 文件唯一识别号
   */
  @ApiModelProperty(value = "文件唯一识别号")
  @DynamicField(fieldName = "文件唯一识别号", validates = {@Validate(value = NotBlankValidateStrategy.class)}, controllKey = SimpleInputWidget.class)
  private String fileCode;

  /**
   * 原始文件名
   */
  @ApiModelProperty(name = "originalFileName", value = "原始文件名")
  @DynamicField(fieldName = "原始文件名", validates = {@Validate(value = NotBlankValidateStrategy.class)}, controllKey = SimpleInputWidget.class)
  private String originalFileName;
}
