package com.biz.crm.sfa.business.template.outstore.local.repository;

import com.biz.crm.sfa.business.template.outstore.local.entity.OutstoreClock;
import com.biz.crm.sfa.business.template.outstore.local.mapper.OutstoreClockMapper;
import org.springframework.beans.factory.annotation.Autowired;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.stereotype.Component;
import org.springframework.data.domain.Pageable;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import java.util.List;

/**
 * 离店打卡(OutstoreClock)Repository
 *
 * @author rentao
 * @since 2022-06-16 16:21:37
 */
@Component
public class OutstoreClockRepository extends ServiceImpl<OutstoreClockMapper, OutstoreClock> {

  @Autowired private OutstoreClockMapper outstoreClockMapper;

  /**
   * 分页查询
   *
   * @param pageable 分页参数
   * @param outstoreClock 分页条件
   * @return
   */
  public Page<OutstoreClock> findByConditions(Pageable pageable, OutstoreClock outstoreClock) {
    Page<OutstoreClock> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    Page<OutstoreClock> pageList = this.outstoreClockMapper.findByConditions(page, outstoreClock);
    return pageList;
  }

  /**
   * 删除
   *
   * @param parentCode
   * @param dynamicKey
   * @return
   */
  public void deleteByParentCodeAndDynamicKey(String parentCode, String dynamicKey){
    this.lambdaUpdate().eq(OutstoreClock::getParentCode,parentCode)
        .eq(OutstoreClock::getDynamicKey,dynamicKey)
        .remove();
  }

  /**
   * 离店打卡单个查询
   *
   * @param parentCode
   * @param dynamicKey
   * @return
   */
  public OutstoreClock findByParentCodeAndDynamicKey(String parentCode, String dynamicKey){
   return this.lambdaQuery().eq(OutstoreClock::getParentCode,parentCode)
        .eq(OutstoreClock::getDynamicKey,dynamicKey)
        .one();
  }
}
