package com.biz.crm.sfa.business.template.outstore.local.strategy;

import com.biz.crm.common.form.sdk.model.DynamicFormOperationStrategy;
import com.biz.crm.sfa.business.step.sdk.register.StepFormModuleRegister;
import com.biz.crm.sfa.business.template.outstore.local.entity.OutstoreClock;
import com.biz.crm.sfa.business.template.outstore.local.models.LocInfoModel;
import com.biz.crm.sfa.business.template.outstore.local.models.OutstoreClockModel;
import com.biz.crm.sfa.business.template.outstore.local.models.PictureModel;
import com.biz.crm.sfa.business.template.outstore.local.models.StoreInfoModel;
import com.biz.crm.sfa.business.template.outstore.local.service.OutstoreClockService;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;

/**
 * @description: 离店打卡
 * @author: rentao
 * @date: 2022/6/17 14:33
 */
@Component
public class DynamicFormOperationStrategyOutstoreClockModule implements DynamicFormOperationStrategy<OutstoreClockModel> {

  @Autowired
  private StepFormModuleRegister stepFormModuleRegister;
  @Autowired
  private OutstoreClockService outstoreClockService;
  @Autowired
  private NebulaToolkitService nebulaToolkitService;


  /**
   * 日志
   */
  private static final Logger LOGGER = LoggerFactory.getLogger(
      DynamicFormOperationStrategyOutstoreClockModule.class);

  @Override
  public int getOrder() {
    return 11;
  }

  @Override
  public String dynamicFormCode() {
    return StringUtils.uncapitalize(this.getClass().getSimpleName());
  }

  @Override
  public String dynamicFormName() {
    return "离店打卡";
  }

  @Override
  public Class<OutstoreClockModel> dynamicFormClass() {
    return OutstoreClockModel.class;
  }

  @Override
  public String moduleCode() {
    return this.stepFormModuleRegister.moduleCode();
  }

  @Override
  @Transactional
  public void onDynamicFormsDelete(String parentCode, String dynamicKey) {
    LOGGER.info("onDynamicFormsDelete(String parentCode, String dynamicKey)");
    this.outstoreClockService.deleteByParentCodeAndDynamicKey(parentCode, dynamicKey);
  }

  @Override
  @Transactional
  public void onDynamicFormCreate(OutstoreClockModel dynamicForm, String dynamicKey, String parentCode, Object parent) {
    dynamicForm.setParentCode(parentCode);
    dynamicForm.setDynamicKey(dynamicKey);
    LOGGER.info("onDynamicFormCreate(CpuAccessory dynamicForm, String dynamicKey, String parentCode,Object parent)");
    OutstoreClock outstoreClock = this.nebulaToolkitService.copyObjectByBlankList(dynamicForm, OutstoreClock.class, HashSet.class, ArrayList.class);
    this.validateCreateOrUpdate(dynamicForm);
    this.transitionToOutstoreClock(outstoreClock, dynamicForm);
    OutstoreClockModel outstoreClockModel = this.findByParentCode(dynamicKey, parentCode);
    Validate.isTrue(Objects.isNull(outstoreClockModel), "离店打卡数据已存在！");
    this.outstoreClockService.create(outstoreClock);
  }

  @Override
  @Transactional
  public void onDynamicFormModify(OutstoreClockModel dynamicForm, String dynamicKey, String parentCode, Object parent) {
    dynamicForm.setParentCode(parentCode);
    dynamicForm.setDynamicKey(dynamicKey);
    LOGGER.info("onDynamicFormModify(CpuAccessory dynamicForm, String dynamicKey, String parentCode, Object parent)");
    OutstoreClock outstoreClock = this.nebulaToolkitService.copyObjectByBlankList(dynamicForm, OutstoreClock.class, HashSet.class, ArrayList.class);
    this.validateCreateOrUpdate(dynamicForm);
    this.transitionToOutstoreClock(outstoreClock, dynamicForm);
    this.outstoreClockService.update(outstoreClock);
  }

  @Override
  public OutstoreClockModel findByParentCode(String dynamicKey, String parentCode) {
    LOGGER.info("findByParentCode(String dynamicKey(" + dynamicKey + "), String parentCode[" + parentCode + "])");
    OutstoreClock outstoreClock = this.outstoreClockService
        .findByParentCodeAndDynamicKey(parentCode, dynamicKey);
    if (Objects.isNull(outstoreClock)) {
      return null;
    }
    OutstoreClockModel outstoreClockModel = this.nebulaToolkitService.copyObjectByBlankList(outstoreClock, OutstoreClockModel.class, HashSet.class, ArrayList.class);
    this.transitionToOutstoreClockModel(outstoreClock, outstoreClockModel);
    return outstoreClockModel;
  }

  /*
   *
   * 转实体
   * @param instoreClock
   * @param dynamicForm
   * @author rentao
   * @date a
   */
  private void transitionToOutstoreClock(OutstoreClock outstoreClock, OutstoreClockModel dynamicForm) {
    LocInfoModel locInfo = dynamicForm.getLocInfo();
    StoreInfoModel storeInfo = dynamicForm.getStoreInfo();
    List<PictureModel> pictureInfo = dynamicForm.getPictureInfo();
    if (Objects.nonNull(storeInfo)) {
      outstoreClock.setClockPlace(locInfo.getClockPlace());
      outstoreClock.setClockLongitude(locInfo.getClockLongitude());
      outstoreClock.setClockLatitude(locInfo.getClockLatitude());
    }
    outstoreClock.setStoreCode(storeInfo.getStoreCode());
    outstoreClock.setStoreName(storeInfo.getStoreName());
    if (!CollectionUtils.isEmpty(pictureInfo)) {
      outstoreClock.setFileCode(pictureInfo.get(0).getFileCode());
      outstoreClock.setOriginalFileName(pictureInfo.get(0).getOriginalFileName());
    }
  }

  /*
   *
   * 转模型
   * @param instoreClock
   * @param dynamicForm
   * @author rentao
   * @date a
   */
  private void transitionToOutstoreClockModel(OutstoreClock outstoreClock, OutstoreClockModel dynamicForm) {
    LocInfoModel locInfo = new LocInfoModel();
    StoreInfoModel storeInfo = new StoreInfoModel();
    PictureModel pictureInfo = new PictureModel();
    locInfo.setClockPlace(outstoreClock.getClockPlace());
    locInfo.setClockLongitude(outstoreClock.getClockLongitude());
    locInfo.setClockLatitude(outstoreClock.getClockLatitude());
    storeInfo.setStoreCode(outstoreClock.getStoreCode());
    storeInfo.setStoreName(outstoreClock.getStoreName());
    pictureInfo.setFileCode(outstoreClock.getFileCode());
    pictureInfo.setOriginalFileName(outstoreClock.getOriginalFileName());
    dynamicForm.setLocInfo(locInfo);
    dynamicForm.setStoreInfo(storeInfo);
    dynamicForm.setPictureInfo(Collections.singletonList(pictureInfo));
  }

  private void validateCreateOrUpdate(OutstoreClockModel dynamicForm) {
    Validate.notNull(dynamicForm.getStoreInfo(), "进店打卡店铺数据不存在");
    Validate.notBlank(dynamicForm.getStoreInfo().getStoreCode(), "进店打卡店铺编码不存在");
    Validate.notBlank(dynamicForm.getStoreInfo().getStoreName(), "进店打卡店铺名称不存在");
    Validate.notBlank(dynamicForm.getStoreInfo().getStoreType(), "进店打卡店铺类型不存在");
  }


}
