package com.biz.crm.sfa.business.template.sdk.abstracts;

import com.baomidou.mybatisplus.annotation.TableField;
import com.biz.crm.business.common.local.entity.TenantOpEntity;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

import javax.persistence.Column;
import javax.persistence.MappedSuperclass;

/**
 * 动态表单抽象基础类
 *
 * @author songjingen
 */
@Getter
@Setter
@ToString
@NoArgsConstructor
@MappedSuperclass
public abstract class AbstractDynamicTemplateEntity extends TenantOpEntity {
  private static final long serialVersionUID = -9137642152343032974L;

  @ApiModelProperty("执行计划业务编码")
  @TableField(value = "parent_code")
  @Column(name = "parent_code", length = 64, columnDefinition = "varchar(64) COMMENT '执行计划业务编码'")
  private String parentCode;

  @ApiModelProperty("步骤业务编码stepCode")
  @TableField(value = "dynamic_key")
  @Column(name = "dynamic_key", length = 64, columnDefinition = "varchar(64) COMMENT '步骤业务编码stepCode'")
  private String dynamicKey;

  @ApiModelProperty("动态表单全局唯一编码formCode")
  @TableField(value = "dynamic_form_code")
  @Column(name = "dynamic_form_code", columnDefinition = "varchar(255) COMMENT '动态表单全局唯一编码formCode'")
  private String dynamicFormCode;

}
