package com.biz.crm.sfa.business.template.sdk.abstracts;

import com.baomidou.mybatisplus.annotation.TableField;
import com.biz.crm.business.common.sdk.vo.TenantOpVo;
import com.biz.crm.common.form.sdk.field.annotation.DynamicField;
import com.biz.crm.common.form.sdk.field.annotation.Validate;
import com.biz.crm.common.form.sdk.field.validate.NotBlankValidateStrategy;
import com.biz.crm.common.form.sdk.model.DynamicForm;
import com.biz.crm.common.form.sdk.widget.SimpleInputWidget;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * 动态表单model抽象基础类类
 *
 * @author songjingen
 */
@Data
public abstract class AbstractDynamicTemplateModel extends TenantOpVo implements DynamicForm {
  private static final long serialVersionUID = -9137642152343032974L;

  @ApiModelProperty("执行计划业务编码")
  @TableField(value = "parent_code")
  @DynamicField(fieldName = "执行计划业务编码", validates = {@Validate(value = NotBlankValidateStrategy.class)}, controllKey = SimpleInputWidget.class)
  private String parentCode;

  @ApiModelProperty("步骤业务编码stepCode")
  @TableField(value = "dynamic_key")
  @DynamicField(fieldName = "步骤业务编码stepCode", validates = {@Validate(value = NotBlankValidateStrategy.class)}, controllKey = SimpleInputWidget.class)
  private String dynamicKey;

  @ApiModelProperty("动态表单全局唯一编码formCode")
  @TableField(value = "dynamic_form_code")
  @DynamicField(fieldName = "动态表单全局唯一编码formCode", validates = {@Validate(value = NotBlankValidateStrategy.class)}, controllKey = SimpleInputWidget.class)
  private String dynamicFormCode;

  @ApiModelProperty("客户编码")
  @DynamicField(fieldName = "客户编码", validates = {@Validate(value = NotBlankValidateStrategy.class)}, controllKey = SimpleInputWidget.class)
  private String clientCode;

  @ApiModelProperty("客户类型")
  @DynamicField(fieldName = "客户类型", validates = {@Validate(value = NotBlankValidateStrategy.class)}, controllKey = SimpleInputWidget.class)
  private String clientType;

  @ApiModelProperty("客户维度")
  @DynamicField(fieldName = "客户维度", validates = {@Validate(value = NotBlankValidateStrategy.class)}, controllKey = SimpleInputWidget.class)
  private String clientRoute;

  @ApiModelProperty("经度")
  @DynamicField(fieldName = "经度", validates = {@Validate(value = NotBlankValidateStrategy.class)}, controllKey = SimpleInputWidget.class)
  private BigDecimal longitude;

  @ApiModelProperty("纬度")
  @DynamicField(fieldName = "纬度", validates = {@Validate(value = NotBlankValidateStrategy.class)}, controllKey = SimpleInputWidget.class)
  private BigDecimal latitude;

  @ApiModelProperty("是否为步骤表单")
  @DynamicField(fieldName = "是否为步骤表单", validates = {@Validate(value = NotBlankValidateStrategy.class)}, controllKey = SimpleInputWidget.class)
  private Boolean stepFormOrNot;

  @ApiModelProperty("拜访类型")
  @DynamicField(fieldName = "拜访类型", validates = {@Validate(value = NotBlankValidateStrategy.class)}, controllKey = SimpleInputWidget.class)
  private String visitType;

}
