package com.biz.crm.sfa.business.template.sdk.service;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.sfa.business.template.sdk.abstracts.AbstractDynamicTemplateModel;
import com.biz.crm.sfa.business.template.sdk.dto.DynamicTemplateDto;
import com.biz.crm.sfa.business.template.sdk.dto.DynamicTemplateModelDto;
import com.biz.crm.sfa.business.template.sdk.vo.DynamicTemplateVo;
import org.springframework.data.domain.Pageable;

/**
 * 动态表单模板基础服务类
 *
 * @author songjingen
 */
public interface DynamicTemplateService {
  /**
   * 分页查询动态模板
   *
   * @param pageable
   * @param dto
   * @return
   */
  Page<DynamicTemplateVo> findByConditions(Pageable pageable, DynamicTemplateDto dto);

  /**
   * 创建表单信息
   *
   * @param jsonObject
   */
  void handleCreateForm(JSONObject jsonObject);

  /**
   * 编辑表单信息
   *
   * @param jsonObject
   */
  void handleUpdateForm(JSONObject jsonObject);

  /**
   * 查看表单信息
   *
   * @param model
   * @return
   */
  AbstractDynamicTemplateModel findByDynamicTemplateModelDto(DynamicTemplateModelDto model);
}
